/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.NoopAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public record MenuItem(int slot, ResourceLocation item, String name, Optional<List<String>> lore, MenuAction action) {
    public static final Codec<MenuItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(MenuItem::slot), (App)ResourceLocation.CODEC.fieldOf("item").forGetter(MenuItem::item), (App)Codec.STRING.fieldOf("name").forGetter(MenuItem::name), (App)Codec.STRING.listOf().optionalFieldOf("lore").forGetter(MenuItem::lore), (App)MenuAction.CODEC.optionalFieldOf("action", (Object)new NoopAction()).forGetter(MenuItem::action)).apply((Applicative)instance, MenuItem::new));

    public ItemStack makeItemStack() {
        List lore;
        Item itemEntry = BuiltInRegistries.ITEM.getOptional(this.item).orElse(Items.BARRIER);
        MenuAction menuAction = this.action;
        if (menuAction instanceof CraftItemsAction) {
            CraftItemsAction craftItemsAction = (CraftItemsAction)menuAction;
            return this.makeCraftingItemStack(craftItemsAction, itemEntry);
        }
        ItemStack stack = new ItemStack((ItemLike)itemEntry);
        if (!this.name.isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name));
        }
        if (!(lore = this.lore.orElse(List.of())).isEmpty()) {
            ItemLore itemLore = ItemLore.EMPTY;
            for (String line : lore) {
                itemLore = itemLore.withLineAdded((Component)Component.literal((String)line));
            }
            stack.set(DataComponents.LORE, (Object)itemLore);
        }
        return stack;
    }

    private ItemStack makeCraftingItemStack(CraftItemsAction craftItemsAction, Item item) {
        Item craftItemEntry;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!this.name.isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name));
        }
        ArrayList<MutableComponent> itemLore = new ArrayList<MutableComponent>();
        itemLore.add(Component.literal((String)"\u00a7lInputs:\u00a7r"));
        for (CraftItem craftItem : craftItemsAction.inputs()) {
            craftItemEntry = (Item)BuiltInRegistries.ITEM.getValue(craftItem.item());
            itemLore.add(Component.literal((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.getName().getString())));
        }
        itemLore.add(Component.literal((String)""));
        itemLore.add(Component.literal((String)String.format("\u00a7lOutput%s:\u00a7r", craftItemsAction.outputs().size() == 1 ? "" : "s")));
        for (CraftItem craftItem : craftItemsAction.outputs()) {
            craftItemEntry = (Item)BuiltInRegistries.ITEM.getValue(craftItem.item());
            itemLore.add(Component.literal((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.getName().getString())));
        }
        stack.set(DataComponents.LORE, (Object)new ItemLore(itemLore));
        return stack;
    }
}

