/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import dk.magnusjensen.customchestmenus.models.MenuSize;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record PagePayload(MenuSize size, Component title, ItemStack filler, List<Entry> entries) {
    public static final StreamCodec<RegistryFriendlyByteBuf, Entry> ENTRY_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Entry::slot, (StreamCodec)ItemStack.STREAM_CODEC, Entry::stack, Entry::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PagePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(s -> MenuSize.valueOf(s.toUpperCase()), Enum::name), PagePayload::size, (StreamCodec)ComponentSerialization.STREAM_CODEC, PagePayload::title, (StreamCodec)ItemStack.STREAM_CODEC, PagePayload::filler, (StreamCodec)ENTRY_STREAM_CODEC.apply(ByteBufCodecs.list()), PagePayload::entries, PagePayload::new);

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.size);
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.title);
        buf.writeBoolean(this.filler != null && !this.filler.isEmpty());
        if (this.filler != null && !this.filler.isEmpty()) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.filler);
        }
        buf.writeVarInt(this.entries.size());
        for (Entry e : this.entries) {
            buf.writeVarInt(e.slot());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)e.stack());
        }
    }

    public static PagePayload read(RegistryFriendlyByteBuf buf) {
        MenuSize size = (MenuSize)buf.readEnum(MenuSize.class);
        Component title = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        ItemStack filler = buf.readBoolean() ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
        int n = buf.readVarInt();
        ArrayList<Entry> entries = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            int slot = buf.readVarInt();
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            entries.add(new Entry(slot, stack));
        }
        return new PagePayload(size, title, filler, entries);
    }

    public record Entry(int slot, ItemStack stack) {
    }
}

