/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.platform;

import dk.magnusjensen.customchestmenus.Constants;
import dk.magnusjensen.customchestmenus.platform.services.IAttachmentHelper;
import dk.magnusjensen.customchestmenus.registry.NeoforgeAttachmentRegistry;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;

public class NeoforgeAttachmentHelper
implements IAttachmentHelper {
    @Override
    public <T> T getPlayerAttachment(Player player, ResourceLocation id) {
        Optional<AttachmentType<AttachmentType>> attachmentType = NeoforgeAttachmentRegistry.findById(id);
        return attachmentType.map(arg_0 -> ((Player)player).getData(arg_0)).orElse(null);
    }

    @Override
    public <T> void setPlayerAttachment(ServerPlayer player, T attachment, ResourceLocation id) {
        Optional attachmentType = NeoforgeAttachmentRegistry.findById(id);
        if (attachmentType.isEmpty()) {
            Constants.LOGGER.error("No attachment found for {}", attachment.getClass());
            return;
        }
        player.setData(attachmentType.get(), attachment);
    }
}

