/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import com.mojang.brigadier.CommandDispatcher;
import dk.magnusjensen.customchestmenus.commands.CommandHandler;
import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.network.PacketHandler;
import dk.magnusjensen.customchestmenus.registries.CustomChestMenuRegistry;
import dk.magnusjensen.customchestmenus.registries.MenuRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="customchestmenus")
@Mod.EventBusSubscriber(modid="customchestmenus")
public class CustomChestMenus {
    public static final String MODID = "customchestmenus";
    public static final Logger LOGGER = LogManager.getLogger();

    public CustomChestMenus() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MenuRegistry.MENUS.register(modBus);
        PacketHandler.register();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CustomChestMenuRegistry.loadMenus(event.getServer());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandHandler.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void openMenu(ServerPlayer player, final MenuDefinition def, final int pageIndex) {
        final PagePayload payload = def.build(def, pageIndex);
        MenuProvider provider = new MenuProvider(){

            public Component m_5446_() {
                return payload.title();
            }

            public CustomChestMenu createMenu(int windowId, Inventory inv, Player p) {
                CustomChestMenu cont = new CustomChestMenu(windowId, inv, def.id(), payload);
                cont.populateFromDefinition(def, pageIndex);
                return cont;
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> {
            buf.m_130070_(def.id());
            payload.write((FriendlyByteBuf)buf);
        });
    }

    public static void openMenu(ServerPlayer player, String menuId, int pageIndex) {
        MenuDefinition def = CustomChestMenuRegistry.get(menuId);
        if (def == null) {
            return;
        }
        CustomChestMenus.openMenu(player, def, pageIndex);
    }
}

