/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.NoopAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record MenuItem(int slot, ResourceLocation item, String name, Optional<List<String>> lore, MenuAction action) {
    public static final Codec<MenuItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(MenuItem::slot), (App)ResourceLocation.f_135803_.fieldOf("item").forGetter(MenuItem::item), (App)Codec.STRING.fieldOf("name").forGetter(MenuItem::name), (App)Codec.STRING.listOf().optionalFieldOf("lore").forGetter(MenuItem::lore), (App)MenuAction.CODEC.optionalFieldOf("action", (Object)new NoopAction()).forGetter(MenuItem::action)).apply((Applicative)instance, MenuItem::new));

    public ItemStack makeItemStack() {
        List lore;
        Item itemEntry = BuiltInRegistries.f_257033_.m_6612_(this.item).orElse(Items.f_42127_);
        MenuAction menuAction = this.action;
        if (menuAction instanceof CraftItemsAction) {
            CraftItemsAction craftItemsAction = (CraftItemsAction)menuAction;
            return this.makeCraftingItemStack(craftItemsAction, itemEntry);
        }
        ItemStack stack = new ItemStack((ItemLike)itemEntry);
        if (!this.name.isEmpty()) {
            stack.m_41714_((Component)Component.m_237113_((String)this.name));
        }
        if (!(lore = this.lore.orElse(List.of())).isEmpty()) {
            ListTag loreTag = new ListTag();
            for (String line : lore) {
                loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)line))));
            }
            CompoundTag tag = stack.m_41783_();
            CompoundTag display = tag.m_128469_("display");
            display.m_128365_("Lore", (Tag)loreTag);
            stack.m_41751_(tag);
        }
        return stack;
    }

    private ItemStack makeCraftingItemStack(CraftItemsAction craftItemsAction, Item item) {
        Item craftItemEntry;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!this.name.isEmpty()) {
            stack.m_41714_((Component)Component.m_237113_((String)this.name));
        }
        ListTag loreTag = new ListTag();
        loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u00a7lInputs:\u00a7r"))));
        for (CraftItem craftItem : craftItemsAction.inputs()) {
            craftItemEntry = (Item)BuiltInRegistries.f_257033_.m_7745_(craftItem.item());
            loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.m_41466_().getString())))));
        }
        loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)""))));
        loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)String.format("\u00a7lOutput%s:\u00a7r", craftItemsAction.outputs().size() == 1 ? "" : "s")))));
        for (CraftItem craftItem : craftItemsAction.outputs()) {
            craftItemEntry = (Item)BuiltInRegistries.f_257033_.m_7745_(craftItem.item());
            loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.m_41466_().getString())))));
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag display = tag.m_128469_("display");
        display.m_128365_("Lore", (Tag)loreTag);
        stack.m_41751_(tag);
        return stack;
    }
}

