/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuActionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public record CraftItemsAction(List<CraftItem> inputs, List<CraftItem> outputs) implements MenuAction
{
    public static final Codec<CraftItemsAction> CODEC = RecordCodecBuilder.create(i -> i.group((App)CraftItem.CODEC.listOf().fieldOf("inputs").forGetter(CraftItemsAction::inputs), (App)CraftItem.CODEC.listOf().fieldOf("outputs").forGetter(CraftItemsAction::outputs)).apply((Applicative)i, CraftItemsAction::new));

    @Override
    public MenuActionType type() {
        return MenuActionType.CRAFT_ITEMS;
    }

    public boolean canCraft(ServerPlayer player) {
        for (Integer slot : this.getInputSlots(player).keySet()) {
            if (slot != -1) continue;
            return false;
        }
        return true;
    }

    public Map<Integer, Integer> getInputSlots(ServerPlayer player) {
        HashMap<Integer, Integer> inputSlots = new HashMap<Integer, Integer>();
        for (CraftItem item : this.inputs) {
            ItemStack toFind = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(item.item()), item.quantity());
            int slot = player.m_150109_().m_36043_(toFind);
            inputSlots.put(slot, item.quantity());
        }
        return inputSlots;
    }
}

