/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.registries;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dk.magnusjensen.customchestmenus.CustomChestMenus;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class CustomChestMenuRegistry {
    private static final Map<String, MenuDefinition> MENUS = new HashMap<String, MenuDefinition>();

    private static Path worldMenuDir(MinecraftServer server) throws IOException {
        Path root = server.m_129843_(LevelResource.f_78182_);
        Path dir = root.resolve("serverconfig").resolve("customchestmenus");
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    public static void loadMenus(MinecraftServer server) {
        Path customMenusPath;
        MENUS.clear();
        try {
            customMenusPath = CustomChestMenuRegistry.worldMenuDir(server);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int loaded = 0;
        try (Stream<Path> files = Files.list(customMenusPath);){
            for (Path p : files.filter(f -> f.toString().endsWith(".json"))::iterator) {
                if (!CustomChestMenuRegistry.loadMenuFile(p)) continue;
                ++loaded;
            }
        }
        catch (IOException e) {
            CustomChestMenus.LOGGER.error("Failed to list {}", (Object)customMenusPath.toAbsolutePath(), (Object)e);
        }
        CustomChestMenus.LOGGER.info("Loaded {} menu(s) from {}", (Object)loaded, (Object)customMenusPath.toAbsolutePath());
    }

    private static boolean loadMenuFile(Path path) {
        try {
            String raw = Files.readString(path);
            JsonElement element = JsonParser.parseString((String)raw);
            Optional result = MenuDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(err -> CustomChestMenus.LOGGER.warn("Menu parse error in {}: {}", (Object)path.getFileName(), err));
            if (result.isEmpty()) {
                CustomChestMenus.LOGGER.warn("Skipping {}, failed to parse.", (Object)path.getFileName());
                return false;
            }
            MenuDefinition menu = (MenuDefinition)result.get();
            MenuDefinition previous = MENUS.put(menu.id(), menu);
            if (previous != null) {
                CustomChestMenus.LOGGER.warn("Duplicate menu id '{}' detected. Overwriting previous definition from another file with {}.", (Object)menu.id(), (Object)path.getFileName());
            } else {
                CustomChestMenus.LOGGER.debug("Loaded menu '{}' from {}", (Object)menu.id(), (Object)path.getFileName());
            }
            return true;
        }
        catch (Exception e) {
            CustomChestMenus.LOGGER.error("Exception while loading {}", (Object)path.toAbsolutePath(), (Object)e);
            return false;
        }
    }

    public static MenuDefinition get(String id) {
        return MENUS.get(id);
    }

    public static Collection<MenuDefinition> all() {
        return Collections.unmodifiableCollection(MENUS.values());
    }
}

