/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dk.magnusjensen.customchestmenus.commands.CommandHandler;
import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.registries.CustomChestMenuRegistry;
import dk.magnusjensen.customchestmenus.registries.MenuRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="customchestmenus")
@EventBusSubscriber(modid="customchestmenus")
public class CustomChestMenus {
    public static final String MODID = "customchestmenus";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CustomChestMenus(IEventBus modEventBus, ModContainer modContainer) {
        MenuRegistry.MENUS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CustomChestMenuRegistry.loadMenus(event.getServer());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandHandler.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void openMenu(ServerPlayer player, final MenuDefinition def, final int pageIndex) {
        final PagePayload payload = def.build(def, pageIndex);
        MenuProvider provider = new MenuProvider(){

            public Component getDisplayName() {
                return payload.title();
            }

            public CustomChestMenu createMenu(int windowId, Inventory inv, Player p) {
                CustomChestMenu cont = new CustomChestMenu(windowId, inv, def.id(), payload);
                cont.populateFromDefinition(def, pageIndex);
                return cont;
            }
        };
        player.openMenu(provider, buf -> {
            buf.writeUtf(def.id());
            payload.write((RegistryFriendlyByteBuf)buf);
        });
    }

    public static void openMenu(ServerPlayer player, String menuId, int pageIndex) {
        MenuDefinition def = CustomChestMenuRegistry.get(menuId);
        if (def == null) {
            return;
        }
        CustomChestMenus.openMenu(player, def, pageIndex);
    }
}

