/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import dk.magnusjensen.customchestmenus.models.MenuSize;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.item.ItemStack;

public record PagePayload(MenuSize size, Component title, @Nullable ItemStack filler, List<Entry> entries) {
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.size);
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)this.title);
        buf.writeBoolean(this.filler != null && !this.filler.isEmpty());
        if (this.filler != null && !this.filler.isEmpty()) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.filler);
        }
        buf.writeVarInt(this.entries.size());
        for (Entry e : this.entries) {
            buf.writeVarInt(e.slot());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)e.stack());
        }
    }

    public static PagePayload read(RegistryFriendlyByteBuf buf) {
        MenuSize size = (MenuSize)buf.readEnum(MenuSize.class);
        Component title = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        ItemStack filler = buf.readBoolean() ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
        int n = buf.readVarInt();
        ArrayList<Entry> entries = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            int slot = buf.readVarInt();
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            entries.add(new Entry(slot, stack));
        }
        return new PagePayload(size, title, filler, entries);
    }

    public record Entry(int slot, ItemStack stack) {
    }
}

