/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus;

import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.MenuItem;
import dk.magnusjensen.customchestmenus.models.MenuPage;
import dk.magnusjensen.customchestmenus.models.MenuSize;
import dk.magnusjensen.customchestmenus.models.actions.CommandAction;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.PageAction;
import dk.magnusjensen.customchestmenus.models.actions.TeleportAction;
import dk.magnusjensen.customchestmenus.network.UpdateMenuTitleS2C;
import dk.magnusjensen.customchestmenus.platform.Services;
import dk.magnusjensen.customchestmenus.registry.CustomChestMenuRegistry;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Math;

public final class ActionExecutor {
    public static void onClick(ServerPlayer player, String menuId, int pageIndex, int slot) {
        MenuDefinition menu = CustomChestMenuRegistry.get(menuId);
        if (menu == null) {
            return;
        }
        if (!ActionExecutor.inBounds(menu.size(), slot)) {
            return;
        }
        MenuPage page = menu.pages().get(java.lang.Math.max(0, java.lang.Math.min(pageIndex, menu.pages().size() - 1)));
        MenuItem item = page.items().stream().filter(it -> it.slot() == slot).findFirst().orElse(null);
        if (item == null) {
            return;
        }
        switch (item.action().type()) {
            case CLOSE: {
                player.closeContainer();
                break;
            }
            case NEXT_PAGE: {
                ActionExecutor.openPage(player, menu, pageIndex, java.lang.Math.min(pageIndex + 1, menu.pages().size() - 1));
                break;
            }
            case PREVIOUS_PAGE: {
                ActionExecutor.openPage(player, menu, pageIndex, java.lang.Math.max(pageIndex - 1, 0));
                break;
            }
            case JUMP_TO_PAGE: {
                PageAction pageAction = (PageAction)item.action();
                ActionExecutor.openPage(player, menu, pageIndex, Math.clamp((int)pageAction.targetPage().orElse(0), (int)0, (int)(menu.pages().size() - 1)));
                break;
            }
            case TELEPORT: {
                TeleportAction tp = (TeleportAction)item.action();
                ActionExecutor.doTeleport(player, tp);
                player.closeContainer();
                break;
            }
            case COMMAND: {
                CommandAction command = (CommandAction)item.action();
                ActionExecutor.runCommand(player, command);
                break;
            }
            case CRAFT_ITEMS: {
                CraftItemsAction action = (CraftItemsAction)item.action();
                ActionExecutor.craftItems(player, action);
            }
        }
    }

    private static void openPage(ServerPlayer player, MenuDefinition menu, int currentPage, int newPage) {
        CustomChestMenu ccm;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof CustomChestMenu) || !(ccm = (CustomChestMenu)abstractContainerMenu).menuId().equals(menu.id())) {
            return;
        }
        if (newPage == currentPage) {
            return;
        }
        ccm.populateFromDefinition(menu, newPage);
        int clampedPage = Math.clamp((int)0, (int)(menu.pages().size() - 1), (int)newPage);
        UpdateMenuTitleS2C packet = new UpdateMenuTitleS2C(ccm.menuId(), menu.pages().get(clampedPage).titleAsComponent());
        Services.NETWORK.sendToPlayer(player, packet);
    }

    private static void doTeleport(ServerPlayer player, TeleportAction tp) {
        ServerLevel target = player.getServer().getLevel(tp.dimension().map(ResourceLocation::tryParse).map(rl -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rl)).orElse(player.level().dimension()));
        if (target == null) {
            return;
        }
        player.teleportTo(target, tp.x() + 0.5, tp.y(), tp.z() + 0.5, Set.of(), player.getYRot(), player.getXRot());
    }

    private static boolean inBounds(MenuSize size, int slot) {
        int max = size == MenuSize.SINGLE ? 27 : 54;
        return slot >= 0 && slot < max;
    }

    private static void runCommand(ServerPlayer player, CommandAction action) {
        MinecraftServer server = player.getServer();
        CommandSourceStack stack = server.createCommandSourceStack();
        if (action.shouldRunAsPlayer()) {
            stack = player.createCommandSourceStack();
        }
        for (String cmd : action.commands()) {
            String finalCmd = cmd.replace("%player%", player.getScoreboardName()).replace("%uuid%", player.getStringUUID());
            server.getCommands().performPrefixedCommand(stack, finalCmd);
        }
    }

    private static void craftItems(ServerPlayer player, CraftItemsAction action) {
        if (!action.canCraft(player)) {
            player.sendSystemMessage((Component)Component.literal((String)"Can't craft, missing input items"));
            return;
        }
        Map<Integer, Integer> slotToQuantity = action.getInputSlots(player);
        for (Map.Entry<Integer, Integer> entry : slotToQuantity.entrySet()) {
            player.getInventory().removeItem(entry.getKey().intValue(), entry.getValue().intValue());
        }
        for (CraftItem item : action.outputs()) {
            ItemStack toGive = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(item.item()), item.quantity());
            if (player.getInventory().add(toGive)) continue;
            player.drop(toGive, false);
        }
    }
}

