/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import dk.magnusjensen.customchestmenus.models.MenuSize;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public record PagePayload(MenuSize size, Component title, @Nullable ItemStack filler, List<Entry> entries) {
    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.size);
        buf.writeComponent(this.title);
        buf.writeBoolean(this.filler != null && !this.filler.isEmpty());
        if (this.filler != null && !this.filler.isEmpty()) {
            buf.writeItem(this.filler);
        }
        buf.writeVarInt(this.entries.size());
        for (Entry e : this.entries) {
            buf.writeVarInt(e.slot());
            buf.writeItem(e.stack());
        }
    }

    public static PagePayload read(FriendlyByteBuf buf) {
        MenuSize size = (MenuSize)buf.readEnum(MenuSize.class);
        Component title = buf.readComponent();
        ItemStack filler = buf.readBoolean() ? buf.readItem() : ItemStack.EMPTY;
        int n = buf.readVarInt();
        ArrayList<Entry> entries = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            int slot = buf.readVarInt();
            ItemStack stack = buf.readItem();
            entries.add(new Entry(slot, stack));
        }
        return new PagePayload(size, title, filler, entries);
    }

    public record Entry(int slot, ItemStack stack) {
    }
}

