/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.platform;

import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.network.CustomPacket;
import dk.magnusjensen.customchestmenus.network.ForgeNetwork;
import dk.magnusjensen.customchestmenus.platform.services.INetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class ForgeNetworkHelper
implements INetworkHelper {
    @Override
    public void sendToPlayer(ServerPlayer player, CustomPacket packet) {
        ForgeNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    @Override
    public void openChestMenuScreen(ServerPlayer player, final MenuDefinition definition, final int pageIndex) {
        final PagePayload payload = definition.build(pageIndex);
        MenuProvider provider = new MenuProvider(){

            public Component getDisplayName() {
                return payload.title();
            }

            public CustomChestMenu createMenu(int windowId, Inventory inv, Player p) {
                CustomChestMenu cont = new CustomChestMenu(windowId, inv, definition.id(), payload);
                cont.populateFromDefinition(definition, pageIndex);
                return cont;
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> {
            buf.writeUtf(definition.id());
            payload.write((FriendlyByteBuf)buf);
        });
    }
}

