/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.platform;

import dk.magnusjensen.customchestmenus.menu.CustomChestMenu;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.network.CustomPacket;
import dk.magnusjensen.customchestmenus.platform.services.INetworkHelper;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class FabricNetworkHelper
implements INetworkHelper {
    @Override
    public void sendToPlayer(ServerPlayer player, CustomPacket packet) {
        FriendlyByteBuf buffer = PacketByteBufs.create();
        packet.write(buffer);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)packet.getId(), (FriendlyByteBuf)buffer);
    }

    @Override
    public void openChestMenuScreen(ServerPlayer player, final MenuDefinition definition, final int pageIndex) {
        final PagePayload payload = definition.build(pageIndex);
        player.openMenu((MenuProvider)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(ServerPlayer serverPlayer, FriendlyByteBuf friendlyByteBuf) {
                friendlyByteBuf.writeUtf(definition.id());
                payload.write(friendlyByteBuf);
            }

            public Component getDisplayName() {
                return payload.title();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                CustomChestMenu menu = new CustomChestMenu(i, inventory, definition.id(), payload);
                menu.populateFromDefinition(definition, pageIndex);
                return menu;
            }
        });
    }
}

