/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.menu;

import dk.magnusjensen.customchestmenus.ActionExecutor;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.MenuItem;
import dk.magnusjensen.customchestmenus.models.MenuPage;
import dk.magnusjensen.customchestmenus.models.MenuSize;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CustomChestMenu
extends AbstractContainerMenu {
    private final SimpleContainer backing;
    private final int slotCount;
    private final String customChestMenuId;
    private int pageIndex;

    public CustomChestMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readUtf(), PagePayload.read(extraData));
    }

    public CustomChestMenu(int containerId, Inventory playerInventory, String customChestMenuId, PagePayload payload) {
        super(Services.REGISTRY.getCustomChestMenuType(), containerId);
        this.slotCount = payload.size() == MenuSize.SINGLE ? 27 : 54;
        this.backing = new SimpleContainer(this.slotCount);
        this.customChestMenuId = customChestMenuId;
        this.addGridSlots((Container)this.backing, this.getRowCount());
        this.addPlayerInventoryLocked(playerInventory, this.getRowCount());
    }

    private void addGridSlots(Container container, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                int x = 8 + col * 18;
                int y = 18 + row * 18;
                this.addSlot(new LockedSlot(container, index, x, y));
            }
        }
    }

    private void addPlayerInventoryLocked(Inventory inv, int gridRows) {
        int x;
        int col;
        int baseY = 18 + gridRows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                int y = baseY + row * 18;
                this.addSlot(new LockedSlot((Container)inv, col + row * 9 + 9, x, y));
            }
        }
        int hotbarY = baseY + 58;
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            this.addSlot(new LockedSlot((Container)inv, col, x, hotbarY));
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (clickType == ClickType.QUICK_MOVE || clickType == ClickType.SWAP || clickType == ClickType.THROW || clickType == ClickType.QUICK_CRAFT || clickType == ClickType.PICKUP_ALL || clickType == ClickType.CLONE) {
            return;
        }
        if (slotId >= 0 && slotId < this.slotCount && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ActionExecutor.onClick(sp, this.customChestMenuId, this.pageIndex, slotId);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    protected boolean moveItemStackTo(ItemStack stack, int start, int end, boolean reverse) {
        return false;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return false;
    }

    public boolean canDragTo(Slot slot) {
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void populateFromDefinition(MenuDefinition def, int pageIdx) {
        int pageCount = def.pages().size();
        if (pageCount == 0) {
            this.backing.clearContent();
            this.broadcastChanges();
            return;
        }
        this.pageIndex = Math.max(0, Math.min(pageIdx, pageCount - 1));
        int slotCount = CustomChestMenu.sizeFor(def.size());
        this.backing.clearContent();
        def.filler().ifPresent(f -> {
            ItemStack filler = f.makeItemStack();
            for (int i = 0; i < slotCount; ++i) {
                this.backing.setItem(i, filler.copy());
            }
        });
        MenuPage page = def.pages().get(this.pageIndex);
        for (MenuItem it : page.items()) {
            int slot = it.slot();
            if (!CustomChestMenu.inBounds(slot, slotCount)) continue;
            ItemStack stack = it.makeItemStack();
            this.backing.setItem(slot, stack);
        }
        this.broadcastChanges();
    }

    private static boolean inBounds(int slot, int slotCount) {
        return slot >= 0 && slot < slotCount;
    }

    private static int sizeFor(MenuSize size) {
        return size == MenuSize.SINGLE ? 27 : 54;
    }

    public int getRowCount() {
        return this.slotCount == 27 ? 3 : 6;
    }

    public String menuId() {
        return this.customChestMenuId;
    }

    private static final class LockedSlot
    extends Slot {
        LockedSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }

        public int getMaxStackSize(ItemStack stack) {
            return 0;
        }

        public boolean isActive() {
            return true;
        }

        public boolean isHighlightable() {
            return false;
        }
    }
}

