/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.models.actions.CraftItem;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.NoopAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record MenuItem(int slot, ResourceLocation item, String name, Optional<List<String>> lore, MenuAction action) {
    public static final Codec<MenuItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(MenuItem::slot), (App)ResourceLocation.CODEC.fieldOf("item").forGetter(MenuItem::item), (App)Codec.STRING.fieldOf("name").forGetter(MenuItem::name), (App)Codec.STRING.listOf().optionalFieldOf("lore").forGetter(MenuItem::lore), (App)MenuAction.CODEC.optionalFieldOf("action", (Object)new NoopAction()).forGetter(MenuItem::action)).apply((Applicative)instance, MenuItem::new));

    public ItemStack makeItemStack() {
        List lore;
        Item itemEntry = BuiltInRegistries.ITEM.getOptional(this.item).orElse(Items.BARRIER);
        MenuAction menuAction = this.action;
        if (menuAction instanceof CraftItemsAction) {
            CraftItemsAction craftItemsAction = (CraftItemsAction)menuAction;
            return this.makeCraftingItemStack(craftItemsAction, itemEntry);
        }
        ItemStack stack = new ItemStack((ItemLike)itemEntry);
        if (!this.name.isEmpty()) {
            stack.setHoverName((Component)Component.literal((String)this.name));
        }
        if (!(lore = this.lore.orElse(List.of())).isEmpty()) {
            ListTag loreTag = new ListTag();
            for (String line : lore) {
                loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)line))));
            }
            CompoundTag tag = stack.getTag();
            CompoundTag display = tag.getCompound("display");
            display.put("Lore", (Tag)loreTag);
            stack.setTag(tag);
        }
        return stack;
    }

    private ItemStack makeCraftingItemStack(CraftItemsAction craftItemsAction, Item item) {
        Item craftItemEntry;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!this.name.isEmpty()) {
            stack.setHoverName((Component)Component.literal((String)this.name));
        }
        ListTag loreTag = new ListTag();
        loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"\u00a7lInputs:\u00a7r"))));
        for (CraftItem craftItem : craftItemsAction.inputs()) {
            craftItemEntry = (Item)BuiltInRegistries.ITEM.get(craftItem.item());
            loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.getDescription().getString())))));
        }
        loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)""))));
        loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)String.format("\u00a7lOutput%s:\u00a7r", craftItemsAction.outputs().size() == 1 ? "" : "s")))));
        for (CraftItem craftItem : craftItemsAction.outputs()) {
            craftItemEntry = (Item)BuiltInRegistries.ITEM.get(craftItem.item());
            loreTag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)(" - " + craftItem.quantity() + "x " + craftItemEntry.getDescription().getString())))));
        }
        CompoundTag tag = stack.getTag();
        CompoundTag display = tag.getCompound("display");
        display.put("Lore", (Tag)loreTag);
        stack.setTag(tag);
        return stack;
    }
}

