/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dk.magnusjensen.customchestmenus.models.MenuValidationException;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuActionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record CommandAction(List<String> commands, Optional<Boolean> runAsPlayer) implements MenuAction
{
    public static final Codec<String> NON_BLANK = Codec.STRING.flatXmap(s -> s != null && !s.isBlank() ? DataResult.success((Object)s) : DataResult.error(() -> "String must be non-blank"), DataResult::success);
    public static final Codec<CommandAction> CODEC = RecordCodecBuilder.create(i -> i.group((App)NON_BLANK.optionalFieldOf("command").forGetter(ignored -> Optional.empty()), (App)NON_BLANK.listOf().optionalFieldOf("commands").forGetter(ignored -> Optional.empty()), (App)Codec.BOOL.optionalFieldOf("run_as_player").forGetter(CommandAction::runAsPlayer)).apply((Applicative)i, (commandOpt, commandsOpt, runAsPlayer) -> {
        if (commandOpt.isPresent() && commandsOpt.isPresent()) {
            throw new MenuValidationException("Cannot have both 'command' and 'commands' fields set");
        }
        if (commandOpt.isEmpty() && commandsOpt.isEmpty()) {
            throw new MenuValidationException("Either 'command' or 'commands' field must be present");
        }
        ArrayList<String> commands = new ArrayList<String>();
        commandOpt.ifPresent(commands::add);
        commandsOpt.ifPresent(commands::addAll);
        return new CommandAction((List<String>)commands, (Optional<Boolean>)runAsPlayer);
    }));

    @Override
    public MenuActionType type() {
        return MenuActionType.COMMAND;
    }

    public boolean shouldRunAsPlayer() {
        return this.runAsPlayer.orElse(false);
    }
}

