/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dk.magnusjensen.customchestmenus.models.MenuDefinitionV1;
import dk.magnusjensen.customchestmenus.models.MenuItem;
import dk.magnusjensen.customchestmenus.models.MenuPage;
import dk.magnusjensen.customchestmenus.models.MenuSize;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public record MenuDefinition(String id, String name, MenuSize size, Optional<MenuItem> filler, List<MenuPage> pages) {
    public static final Codec<MenuDefinition> CODEC = new Codec<MenuDefinition>(){

        public <T> DataResult<Pair<MenuDefinition, T>> decode(DynamicOps<T> ops, T input) {
            Dynamic dyn = new Dynamic(ops, input);
            Optional verRes = dyn.get("format_version").asNumber().result();
            if (verRes.isEmpty()) {
                return DataResult.error(() -> "Missing format_version");
            }
            int version = ((Number)verRes.get()).intValue();
            return switch (version) {
                case 1 -> MenuDefinitionV1.CODEC.decode(ops, input).map(pair -> pair.mapFirst(MenuDefinitionV1::toMenuDefinition));
                default -> DataResult.error(() -> "Unsupported format_version: " + version);
            };
        }

        public <T> DataResult<T> encode(MenuDefinition value, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "Encoding MenuDefinition is not supported");
        }
    };

    public PagePayload build(int pageIndex) {
        MenuPage page = this.pages().get(pageIndex);
        class_1799 filler = class_1799.field_8037;
        if (this.filler().isPresent()) {
            MenuItem f = this.filler().get();
            filler = f.makeItemStack();
        }
        ArrayList<PagePayload.Entry> entries = new ArrayList<PagePayload.Entry>();
        for (MenuItem it : page.items()) {
            entries.add(new PagePayload.Entry(it.slot(), it.makeItemStack()));
        }
        return new PagePayload(this.size, (class_2561)class_2561.method_43470((String)page.title()), filler, entries);
    }
}

