/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.models.actions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dk.magnusjensen.customchestmenus.models.actions.CloseAction;
import dk.magnusjensen.customchestmenus.models.actions.CommandAction;
import dk.magnusjensen.customchestmenus.models.actions.CraftItemsAction;
import dk.magnusjensen.customchestmenus.models.actions.MenuAction;
import dk.magnusjensen.customchestmenus.models.actions.NoopAction;
import dk.magnusjensen.customchestmenus.models.actions.PageAction;
import dk.magnusjensen.customchestmenus.models.actions.TeleportAction;
import java.util.Optional;

public enum MenuActionType {
    NOOP("noop", NoopAction.CODEC),
    CLOSE("close", CloseAction.CODEC),
    TELEPORT("teleport", TeleportAction.CODEC),
    NEXT_PAGE("next_page", PageAction.NEXT_CODEC),
    PREVIOUS_PAGE("previous_page", PageAction.PREVIOUS_CODEC),
    JUMP_TO_PAGE("jump_to_page", PageAction.JUMP_TO_PAGE_CODEC),
    COMMAND("command", CommandAction.CODEC),
    CRAFT_ITEMS("craft_items", CraftItemsAction.CODEC);

    private final String id;
    private final MapCodec<? extends MenuAction> codec;
    public static final Codec<MenuActionType> TYPE_CODEC;

    private MenuActionType(String id, MapCodec<? extends MenuAction> codec) {
        this.id = id;
        this.codec = codec;
    }

    public String id() {
        return this.id;
    }

    public static Optional<MenuActionType> byId(String id) {
        for (MenuActionType t : MenuActionType.values()) {
            if (!t.id.equals(id)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public MapCodec<? extends MenuAction> subCodec() {
        return this.codec;
    }

    static {
        TYPE_CODEC = Codec.STRING.flatXmap(s -> MenuActionType.byId(s).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown action type: " + s)), t -> DataResult.success((Object)t.id));
    }
}

