/*
 * Decompiled with CFR 0.152.
 */
package dk.magnusjensen.customchestmenus.menu;

import dk.magnusjensen.customchestmenus.ActionExecutor;
import dk.magnusjensen.customchestmenus.models.MenuDefinition;
import dk.magnusjensen.customchestmenus.models.MenuItem;
import dk.magnusjensen.customchestmenus.models.MenuPage;
import dk.magnusjensen.customchestmenus.models.MenuSize;
import dk.magnusjensen.customchestmenus.models.PagePayload;
import dk.magnusjensen.customchestmenus.platform.Services;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class CustomChestMenu
extends class_1703 {
    private final class_1277 backing;
    private final int slotCount;
    private final String customChestMenuId;
    private int pageIndex;

    public CustomChestMenu(int containerId, class_1661 playerInventory, class_2540 extraData) {
        this(containerId, playerInventory, extraData.method_19772(), PagePayload.read(extraData));
    }

    public CustomChestMenu(int containerId, class_1661 playerInventory, String customChestMenuId, PagePayload payload) {
        super(Services.REGISTRY.getCustomChestMenuType(), containerId);
        this.slotCount = payload.size() == MenuSize.SINGLE ? 27 : 54;
        this.backing = new class_1277(this.slotCount);
        this.customChestMenuId = customChestMenuId;
        this.addGridSlots((class_1263)this.backing, this.getRowCount());
        this.addPlayerInventoryLocked(playerInventory, this.getRowCount());
    }

    private void addGridSlots(class_1263 container, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                int x = 8 + col * 18;
                int y = 18 + row * 18;
                this.method_7621(new LockedSlot(container, index, x, y));
            }
        }
    }

    private void addPlayerInventoryLocked(class_1661 inv, int gridRows) {
        int x;
        int col;
        int baseY = 18 + gridRows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 8 + col * 18;
                int y = baseY + row * 18;
                this.method_7621(new LockedSlot((class_1263)inv, col + row * 9 + 9, x, y));
            }
        }
        int hotbarY = baseY + 58;
        for (col = 0; col < 9; ++col) {
            x = 8 + col * 18;
            this.method_7621(new LockedSlot((class_1263)inv, col, x, hotbarY));
        }
    }

    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
        if (clickType == class_1713.field_7794 || clickType == class_1713.field_7791 || clickType == class_1713.field_7795 || clickType == class_1713.field_7789 || clickType == class_1713.field_7793 || clickType == class_1713.field_7796) {
            return;
        }
        if (slotId >= 0 && slotId < this.slotCount && player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            ActionExecutor.onClick(sp, this.customChestMenuId, this.pageIndex, slotId);
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    protected boolean method_7616(class_1799 stack, int start, int end, boolean reverse) {
        return false;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return false;
    }

    public boolean method_7615(class_1735 slot) {
        return false;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void populateFromDefinition(MenuDefinition def, int pageIdx) {
        int pageCount = def.pages().size();
        if (pageCount == 0) {
            this.backing.method_5448();
            this.method_7623();
            return;
        }
        this.pageIndex = Math.max(0, Math.min(pageIdx, pageCount - 1));
        int slotCount = CustomChestMenu.sizeFor(def.size());
        this.backing.method_5448();
        def.filler().ifPresent(f -> {
            class_1799 filler = f.makeItemStack();
            for (int i = 0; i < slotCount; ++i) {
                this.backing.method_5447(i, filler.method_7972());
            }
        });
        MenuPage page = def.pages().get(this.pageIndex);
        for (MenuItem it : page.items()) {
            int slot = it.slot();
            if (!CustomChestMenu.inBounds(slot, slotCount)) continue;
            class_1799 stack = it.makeItemStack();
            this.backing.method_5447(slot, stack);
        }
        this.method_7623();
    }

    private static boolean inBounds(int slot, int slotCount) {
        return slot >= 0 && slot < slotCount;
    }

    private static int sizeFor(MenuSize size) {
        return size == MenuSize.SINGLE ? 27 : 54;
    }

    public int getRowCount() {
        return this.slotCount == 27 ? 3 : 6;
    }

    public String menuId() {
        return this.customChestMenuId;
    }

    private static final class LockedSlot
    extends class_1735 {
        LockedSlot(class_1263 container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 player) {
            return false;
        }

        public int method_7676(class_1799 stack) {
            return 0;
        }

        public boolean method_7682() {
            return true;
        }

        public boolean method_51306() {
            return false;
        }
    }
}

