/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import java.util.UUID;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements Errorable {
    @Shadow
    @Final
    PatchedDataComponentMap components;
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
        this.neruina$updateData();
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
        this.neruina$updateData();
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
        this.neruina$updateData();
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Unique
    private void neruina$updateData() {
        CompoundTag tag = new CompoundTag();
        if (this.neruina$errored) {
            tag.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            tag.putString("neruina$tickingEntryId", this.neruina$tickingEntryId.toString());
        }
        CustomData data = CustomData.of((CompoundTag)tag);
        DataComponentPatch.Builder builder = DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)data);
        this.components.applyPatch(builder.build());
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="TAIL")})
    private void readErroredFromComponents(ItemLike item, int count, PatchedDataComponentMap components, CallbackInfo ci) {
        CustomData data = (CustomData)components.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return;
        }
        CompoundTag tag = data.copyTag();
        this.neruina$errored = tag.getBooleanOr("neruina$errored", false);
        this.neruina$tickingEntryId = tag.getString("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
    }
}

