/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.thread;

import com.bawnorton.neruina.exception.AbortedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AbortableCountDownLatch
extends CountDownLatch {
    private boolean aborted = false;

    public AbortableCountDownLatch(int count) {
        super(count);
    }

    public void abort() {
        if (this.aborted || this.getCount() == 0L) {
            return;
        }
        this.aborted = true;
        while (this.getCount() > 0L) {
            this.countDown();
        }
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        if (this.aborted) {
            throw new AbortedException();
        }
    }

    @Override
    public boolean await(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        boolean result = super.await(timeout, unit);
        if (this.aborted) {
            throw new AbortedException();
        }
        return result;
    }
}

