/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.blacklist.Blacklist;
import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class BlacklistHandler {
    private final Map<class_2960, Blacklist> blacklists = new HashMap<class_2960, Blacklist>();

    public void init(MinecraftServer server) {
        Map blacklistFiles = server.method_34864().method_14488("neruina", resource -> resource.method_12832().equals("neruina/blacklist.json"));
        if (blacklistFiles.isEmpty()) {
            Neruina.LOGGER.info("No blacklist files found, skipping blacklist loading");
            return;
        }
        for (Map.Entry entry : blacklistFiles.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource2 = (class_3298)entry.getValue();
            try (JsonReader reader = new JsonReader((Reader)resource2.method_43039());){
                Blacklist blacklist = Blacklist.fromJson(reader);
                if (blacklist != null) {
                    Neruina.LOGGER.info("Blacklist loaded for namespace: \"{}\"", (Object)id.method_12836());
                    this.blacklists.put(id, blacklist);
                    continue;
                }
                Neruina.LOGGER.warn("Invalid blacklist found: {}, ignoring", (Object)id);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    public class_2960 getBlacklistFor(ErroredType type, class_2960 id) {
        for (Map.Entry<class_2960, Blacklist> entry : this.blacklists.entrySet()) {
            class_2960 blacklistId = entry.getKey();
            Blacklist blacklist = entry.getValue();
            if (!blacklist.isBlacklisted(type, id)) continue;
            return blacklistId;
        }
        return null;
    }
}

