/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import java.util.UUID;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements Errorable {
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void writeErroredToOutput(ValueOutput output, CallbackInfo ci) {
        if (this.neruina$errored) {
            output.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            output.putString("neruina$tickingEntryId", this.neruina$tickingEntryId.toString());
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void readErroredFromNbt(ValueInput input, CallbackInfo ci) {
        this.neruina$errored = input.getBooleanOr("neruina$errored", false);
        this.neruina$tickingEntryId = input.getString("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
    }
}

