/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.report;

import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.report.AutoReportConfig;
import com.bawnorton.neruina.util.TickingEntry;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GitHub;

public class IssueFormatter {
    private static final List<Placeholder> PLACEHOLDERS = List.of(new Placeholder("date", true, Restriction.NONE, (config, entry) -> DateFormat.getDateInstance(2).format(new Date())), new Placeholder("time", true, Restriction.NONE, (config, entry) -> DateFormat.getTimeInstance(2).format(new Date())), new Placeholder("modid", true, Restriction.NONE, (config, entry) -> config.modid()), new Placeholder("sources", false, Restriction.NONE, (config, entry) -> {
        Set<String> sources = entry.findPotentialSources();
        return sources.isEmpty() ? "unknown" : String.join((CharSequence)", ", sources);
    }), new Placeholder("type", true, Restriction.NONE, (config, entry) -> entry.getCauseType()), new Placeholder("name", true, Restriction.NONE, (config, entry) -> entry.getCauseName()), new Placeholder("modloader", true, Restriction.NONE, (config, entry) -> Platform.getModLoader().name().toLowerCase(Locale.ROOT)), new Placeholder("modversion", false, Restriction.NONE, (config, entry) -> Platform.getModVersion(config.modid())), new Placeholder("mcversion", false, Restriction.NONE, (config, entry) -> SharedConstants.getCurrentVersion().name()), new Placeholder("report", false, Restriction.BODY, (config, entry) -> "```\n%s\n```".formatted(entry.createCrashReport())));
    private static final String DEFAULT_TITLE = "[Neruina]: Ticking Exception Auto Report (<date> - <time>)";
    private static final String DEFAULT_BODY = "## Automatic Report Created by **NeruinaAutoReporter**\nNeruina detected a ticking exception in \"<modid>\" (<type>: <name>)\n\n### Environment:\n- Minecraft Version: <mcversion>\n- Mod Loader: <modloader>\n- Mod Version: <modversion>\n\n## Report:\n<details>\n<summary>Generated Crash Report</summary>\n\n<report>\n\n</details>\n\nThis issue was created automatically by Neruina's AutoReporter. To opt-out of this feature, remove the `neruina/auto_report.json` file from your mod's data resources.\n";
    private final AutoReportConfig config;
    private final Map<UUID, GHGist> gists = new HashMap<UUID, GHGist>();

    public IssueFormatter(AutoReportConfig config) {
        this.config = config;
    }

    private String replacePlaceholders(String input, Restriction restriction, TickingEntry entry) {
        for (Placeholder placeholder : PLACEHOLDERS) {
            if (!placeholder.restriction().allows(restriction)) continue;
            boolean replaced = false;
            String key = "<" + placeholder.key() + ">";
            if (!input.contains(key)) continue;
            String value = placeholder.apply(this.config, entry);
            for (Placeholder.Modifier modifier : Placeholder.MODIFIERS) {
                if (!modifier.applies(placeholder.key())) continue;
                input = input.replace(modifier.apply(key), value);
                replaced = true;
                break;
            }
            if (replaced) continue;
            input = input.replace(key, value);
        }
        return input;
    }

    public String getTitle(TickingEntry entry) {
        String unverifiedTitle = this.replacePlaceholders(this.config.title() == null ? DEFAULT_TITLE : this.config.title(), Restriction.TITLE, entry);
        if (unverifiedTitle.length() >= 256) {
            return unverifiedTitle.substring(0, 253) + "...";
        }
        return unverifiedTitle;
    }

    public String getBody(TickingEntry entry, GitHub github) {
        String rawBody = this.config.body() == null ? DEFAULT_BODY : this.config.body();
        String unverifiedBody = this.replacePlaceholders(rawBody, Restriction.BODY, entry);
        if (unverifiedBody.length() < 65536) {
            return unverifiedBody;
        }
        String crashReport = "```\n%s\n```".formatted(entry.createCrashReport());
        GHGist gist = this.gists.computeIfAbsent(entry.uuid(), uuid -> {
            try {
                return github.createGist().public_(true).description("Neruina Auto Report").file("crash_report.md", crashReport).create();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create a gist for the crash report", e);
            }
        });
        String gistUrl = gist.getHtmlUrl().toString();
        rawBody = rawBody.replace("<report>", "[Full Crash Report](%s) - Content was too long for an issue body".formatted(gistUrl));
        return this.replacePlaceholders(rawBody, Restriction.BODY, entry);
    }

    private record Placeholder(String key, boolean isModifiable, Restriction restriction, Applier applier) {
        private static final List<Modifier> MODIFIERS = List.of(new Modifier(s -> s.toUpperCase().equals(s), String::toUpperCase), new Modifier(Placeholder::isCapitalized, StringUtils::capitalize));

        private static boolean isCapitalized(String s) {
            return Character.isUpperCase(s.charAt(0)) && s.substring(1).equals(s.substring(1).toLowerCase());
        }

        public String apply(AutoReportConfig config, TickingEntry entry) {
            String result = this.applier.apply(config, entry);
            if (this.isModifiable) {
                return MODIFIERS.stream().filter(modifier -> modifier.applies(this.key)).map(modifier -> modifier.apply(result)).findFirst().orElse(result);
            }
            return result;
        }

        private record Modifier(Predicate<String> predicate, UnaryOperator<String> modification) {
            public boolean applies(String s) {
                return this.predicate.test(s);
            }

            public String apply(String s) {
                return (String)this.modification.apply(s);
            }
        }
    }

    private static enum Restriction {
        TITLE,
        BODY,
        NONE;


        public boolean allows(Restriction restriction) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> true;
                case 0 -> {
                    if (restriction == TITLE) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> restriction == BODY;
            };
        }
    }

    @FunctionalInterface
    private static interface Applier {
        public String apply(AutoReportConfig var1, TickingEntry var2);
    }
}

