/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.util.TickingEntry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public final class PersitanceHandler
extends SavedData {
    private static final Codec<PersitanceHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TickingEntry.CODEC.listOf().fieldOf("tickingEntries").forGetter(PersitanceHandler::getTickingEntries)).apply((Applicative)instance, tickingEntries -> {
        PersitanceHandler handler = new PersitanceHandler();
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        tickingEntries.forEach(tickHandler::addTickingEntryUnsafe);
        return handler;
    }));
    private static final SavedDataType<PersitanceHandler> type = new SavedDataType("neruina", PersitanceHandler::new, CODEC, null);
    private static ServerLevel level;

    public static void updateServerState(MinecraftServer server) {
        level = server.getLevel(Level.OVERWORLD);
        if (level == null) {
            Neruina.LOGGER.error("Level is null, unable to save persistent state.");
            return;
        }
        DimensionDataStorage dataStorage = level.getDataStorage();
        PersitanceHandler handler = (PersitanceHandler)dataStorage.computeIfAbsent(type);
        handler.setDirty();
    }

    public static ServerLevel getLevel() {
        return level;
    }

    private List<TickingEntry> getTickingEntries() {
        return Neruina.getInstance().getTickHandler().getTickingEntries().stream().filter(TickingEntry::isPersitent).toList();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        DataResult dataResult = CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)tag);
        return (CompoundTag)dataResult.getOrThrow();
    }

    private static PersitanceHandler load(CompoundTag tag) {
        DataResult dataResult = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (dataResult.isSuccess()) {
            return (PersitanceHandler)((Object)dataResult.getOrThrow());
        }
        Neruina.LOGGER.warn("Failed to load persitance handler. {}", dataResult.error().orElseThrow());
        return new PersitanceHandler();
    }
}

