package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.stream.JsonReader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class BlacklistHandler {
	private final Map<class_2960, Blacklist> blacklists = new HashMap<>();

	public void init(MinecraftServer server) {
		Map<class_2960, class_3298> blacklistFiles = server.method_34864().method_14488(Neruina.MOD_ID, (resource) -> resource.method_12832().equals("neruina/blacklist.json"));
		if (blacklistFiles.isEmpty()) {
			Neruina.LOGGER.info("No blacklist files found, skipping blacklist loading");
			return;
		}
		for (Map.Entry<class_2960, class_3298> entry : blacklistFiles.entrySet()) {
			class_2960 id = entry.getKey();
			class_3298 resource = entry.getValue();
			try (JsonReader reader = new JsonReader(resource.method_43039())) {
				Blacklist blacklist = Blacklist.fromJson(reader);
				if (blacklist != null) {
					Neruina.LOGGER.info("Blacklist loaded for namespace: \"{}\"", id.method_12836());
					blacklists.put(id, blacklist);
				} else {
					Neruina.LOGGER.warn("Invalid blacklist found: {}, ignoring", id);
				}
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}

	@Nullable
	public class_2960 getBlacklistFor(ErroredType type, class_2960 id) {
		for (Map.Entry<class_2960, Blacklist> entry : blacklists.entrySet()) {
			class_2960 blacklistId = entry.getKey();
			Blacklist blacklist = entry.getValue();
			if (blacklist.isBlacklisted(type, id)) {
				return blacklistId;
			}
		}
		return null;
	}
}
