package com.bawnorton.neruina.version;

import com.bawnorton.neruina.Neruina;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public interface Texter {
	class_2561 LINE_BREAK = literal("\n");
	class_2561 SPACE = literal(" ");
	class_2561 NERUINA_HEADER = withStyle(literal("[Neruina]: "), style -> style.method_10977(class_124.field_1075));

	Map<String, String> FALLBACK_LANG = class_156.method_654(new HashMap<>(), map -> {
		try (InputStream langStream = Texter.class.getClassLoader().getResourceAsStream("assets/neruina/lang/en_us.json")) {
			if (langStream == null) return;

			class_2477.method_29425(langStream, map::put);
		} catch (IOException e) {
			Neruina.LOGGER.error("Failed to load default lang from en_us.json", e);
		}
	});

	static class_2561 literal(String component) {
		return class_2561.method_43470(component);
	}

	static class_2561 translatable(String key, Object... args) {
		return class_2561.method_48322(key, FALLBACK_LANG.getOrDefault(key, key), args);
	}

	static class_2561 empty() {
		return class_2561.method_43473();
	}

	static class_2561 withStyle(class_2561 component, UnaryOperator<class_2583> style) {
		if (component instanceof class_5250 mutableComponent) {
			mutableComponent.method_27694(style);
		}
		return component;
	}

	static class_2561 concat(class_2561... texts) {
		class_5250 component = class_2561.method_43473();
		for (class_2561 t : texts) {
			if (t.getString().isEmpty()) continue;

			component.method_10852(t);
		}
		return component;
	}

	static class_2561 concatDelimited(class_2561 delimiter, class_2561... texts) {
		class_5250 component = class_2561.method_43473();
		for (int i = 0; i < texts.length; i++) {
			component.method_10852(texts[i]);
			if (texts[i].getString().isEmpty()) {
				List<class_2561> siblings = component.method_10855();
				if (!siblings.isEmpty()) {
					siblings.removeLast();
				}
				continue;
			}
			if (i != texts.length - 1) {
				component.method_10852(delimiter);
			}
		}
		return component;
	}

	static class_2561 pad(class_2561 component) {
		if (component.getString().isEmpty()) return component;

		class_5250 padded = class_2561.method_43473();
		padded.method_10852(LINE_BREAK);
		padded.method_10852(component);
		padded.method_10852(LINE_BREAK);
		return padded;
	}

	static class_2561 format(class_2561 component) {
		if (component.getString().isEmpty()) return component;

		return concat(NERUINA_HEADER, withStyle(component, style -> style.method_10977(class_124.field_1061)));
	}

	static class_2558 clickEvent(class_2558.class_2559 action, String value) {
		//? if 1.21.1 {
		return new class_2558(action, value);
		 //?} else {
		/*return switch (action) {
			case OPEN_URL -> new ClickEvent.OpenUrl(URI.create(value));
			case OPEN_FILE -> new ClickEvent.OpenFile(value);
			case RUN_COMMAND -> new ClickEvent.RunCommand(value);
			case SUGGEST_COMMAND -> new ClickEvent.SuggestCommand(value);
			case COPY_TO_CLIPBOARD -> new ClickEvent.CopyToClipboard(value);
			case CHANGE_PAGE -> new ClickEvent.ChangePage(Integer.parseInt(value));
			default -> null;
		};
		*///?}
	}

	//? if 1.21.1 {
    static <T> class_2568 hoverEvent(class_2568.class_5247<T> action, T value) {
        return new class_2568(action, value);
    }
    //?} else {
	/*static HoverEvent hoverEvent(HoverEvent.Action action, Object value) {
		return switch (action) {
			case SHOW_TEXT -> new HoverEvent.ShowText((Component) value);
			case SHOW_ITEM -> new HoverEvent.ShowItem((ItemStack) value);
			case SHOW_ENTITY -> new HoverEvent.ShowEntity((HoverEvent.EntityTooltipInfo) value);
		};
	}
	*///?}
}
