/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.util.TickingEntry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class PersitanceHandler
extends class_18 {
    private static final Codec<PersitanceHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TickingEntry.CODEC.listOf().fieldOf("tickingEntries").forGetter(PersitanceHandler::getTickingEntries)).apply((Applicative)instance, tickingEntries -> {
        PersitanceHandler handler = new PersitanceHandler();
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        tickingEntries.forEach(tickHandler::addTickingEntryUnsafe);
        return handler;
    }));
    private static final class_18.class_8645<PersitanceHandler> type = new class_18.class_8645(PersitanceHandler::new, (compoundTag, provider) -> PersitanceHandler.load(compoundTag), null);
    private static class_3218 level;

    public static void updateServerState(MinecraftServer server) {
        level = server.method_3847(class_1937.field_25179);
        if (level == null) {
            Neruina.LOGGER.error("Level is null, unable to save persistent state.");
            return;
        }
        class_26 dataStorage = level.method_17983();
        PersitanceHandler handler = (PersitanceHandler)dataStorage.method_17924(type, "neruina");
        handler.method_80();
    }

    public static class_3218 getLevel() {
        return level;
    }

    private List<TickingEntry> getTickingEntries() {
        return Neruina.getInstance().getTickHandler().getTickingEntries().stream().filter(TickingEntry::isPersitent).toList();
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 tag, class_7225.class_7874 registries) {
        DataResult dataResult = CODEC.encode((Object)this, (DynamicOps)class_2509.field_11560, (Object)tag);
        return (class_2487)dataResult.getOrThrow();
    }

    private static PersitanceHandler load(class_2487 tag) {
        DataResult dataResult = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag);
        if (dataResult.isSuccess()) {
            return (PersitanceHandler)((Object)dataResult.getOrThrow());
        }
        Neruina.LOGGER.warn("Failed to load persitance handler. {}", dataResult.error().orElseThrow());
        return new PersitanceHandler();
    }
}

