package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_2960;

public record Blacklist(List<String> namespaces, List<class_2960> entities, List<class_2960> blocks, List<class_2960> blockEntities, List<class_2960> items) {
    private static final Gson GSON = new GsonBuilder()
            .setPrettyPrinting()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .registerTypeAdapter(
                    class_2960.class, new TypeAdapter<>() {
                        @Override
                        public void write(JsonWriter out, Object value) throws IOException {
                            if (value instanceof class_2960 id) {
                                out.value(id.toString());
                            } else if (value == null) {
                                out.nullValue();
                            }
                        }

                        @Override
                        public Object read(JsonReader in) throws IOException {
                            String value = in.nextString();
                            class_2960 identifier = class_2960.method_12829(value);
                            if (identifier == null) {
                                throw new IOException("Invalid ResourceLocation: " + value);
                            }
                            return identifier;
                        }
                    }
            )
            .create();

    public static Blacklist fromJson(JsonReader reader) {
        return GSON.fromJson(reader, Blacklist.class);
    }

    public boolean isBlacklisted(ErroredType type, class_2960 id) {
        if (id == null) {
            return false;
        }
        if (namespaces != null) {
            for (String namespace : namespaces) {
                if (id.method_12836().equals(namespace)) {
                    return true;
                }
            }
        }
        return switch (type) {
            case ENTITY -> entities != null && entities.contains(id);
            case BLOCK_STATE -> blocks != null && blocks.contains(id);
            case BLOCK_ENTITY -> blockEntities != null && blockEntities.contains(id);
            case ITEM_STACK -> items != null && items.contains(id);
            default -> false;
        };
    }
}
