/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version;

import com.bawnorton.neruina.Neruina;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface Texter {
    public static final Component LINE_BREAK = Texter.literal("\n");
    public static final Component SPACE = Texter.literal(" ");
    public static final Component NERUINA_HEADER = Texter.withStyle(Texter.literal("[Neruina]: "), style -> style.withColor(ChatFormatting.AQUA));
    public static final Map<String, String> FALLBACK_LANG = (Map)Util.make(new HashMap(), map -> {
        try (InputStream langStream = Texter.class.getClassLoader().getResourceAsStream("assets/neruina/lang/en_us.json");){
            if (langStream == null) {
                return;
            }
            Language.loadFromJson((InputStream)langStream, map::put);
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to load default lang from en_us.json", (Throwable)e);
        }
    });

    public static Component literal(String component) {
        return Component.literal((String)component);
    }

    public static Component translatable(String key, Object ... args) {
        return Component.translatableWithFallback((String)key, (String)FALLBACK_LANG.getOrDefault(key, key), (Object[])args);
    }

    public static Component empty() {
        return Component.empty();
    }

    public static Component withStyle(Component component, UnaryOperator<Style> style) {
        if (component instanceof MutableComponent) {
            MutableComponent mutableComponent = (MutableComponent)component;
            mutableComponent.withStyle(style);
        }
        return component;
    }

    public static Component concat(Component ... texts) {
        MutableComponent component = Component.empty();
        for (Component t : texts) {
            if (t.getString().isEmpty()) continue;
            component.append(t);
        }
        return component;
    }

    public static Component concatDelimited(Component delimiter, Component ... texts) {
        MutableComponent component = Component.empty();
        for (int i = 0; i < texts.length; ++i) {
            component.append(texts[i]);
            if (texts[i].getString().isEmpty()) {
                List siblings = component.getSiblings();
                if (siblings.isEmpty()) continue;
                siblings.removeLast();
                continue;
            }
            if (i == texts.length - 1) continue;
            component.append(delimiter);
        }
        return component;
    }

    public static Component pad(Component component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        MutableComponent padded = Component.empty();
        padded.append(LINE_BREAK);
        padded.append(component);
        padded.append(LINE_BREAK);
        return padded;
    }

    public static Component format(Component component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        return Texter.concat(NERUINA_HEADER, Texter.withStyle(component, style -> style.withColor(ChatFormatting.RED)));
    }

    public static ClickEvent clickEvent(ClickEvent.Action action, String value) {
        return new ClickEvent(action, value);
    }

    public static <T> HoverEvent hoverEvent(HoverEvent.Action<T> action, T value) {
        return new HoverEvent(action, value);
    }
}

