package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2586;

@MixinEnvironment
@Mixin(class_2586.class)
public abstract class BlockEntityMixin implements Errorable {
	@Unique
	private boolean neruina$errored = false;

	@Unique
	private UUID neruina$tickingEntryId = null;

	@Override
	public boolean neruina$isErrored() {
		return neruina$errored;
	}

	@Override
	public void neruina$setErrored() {
		neruina$errored = true;
	}

	@Override
	public void neruina$clearErrored() {
		neruina$errored = false;
	}

	@Override
	public void neruina$setTickingEntryId(UUID uuid) {
		neruina$tickingEntryId = uuid;
	}

	@Override
	public UUID neruina$getTickingEntryId() {
		return neruina$tickingEntryId;
	}

	//? if <=1.21.5 {
    /*@Inject(
            method = "saveAdditional",
            at = @At("HEAD")
    )
    private void writeErrored(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (neruina$errored) {
            tag.putBoolean("neruina$errored", true);
        }
        if (neruina$tickingEntryId != null) {
            tag.putString("neruina$tickingEntryId", neruina$tickingEntryId.toString());
        }
    }

    @Inject(
            method = "loadAdditional",
            at = @At("TAIL")
    )
    private void loadAdditional(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        //? if 1.21.1 {
        /^neruina$errored = tag.getBoolean("neruina$errored");
        if (tag.contains("neruina$tickingEntryId")) {
            neruina$tickingEntryId = UUID.fromString(tag.getString("neruina$tickingEntryId"));
        }
        ^///?} else {
        neruina$errored = tag.getBooleanOr("neruina$errored", false);
        neruina$tickingEntryId = tag.getString("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
        //?}
    }
    *///?} else {
	@Inject(
			method = "saveAdditional",
			at = @At("HEAD")
	)
	private void writeErroredToOutput(class_11372 output, CallbackInfo ci) {
		if (neruina$errored) {
			output.method_71472("neruina$errored", true);
		}
		if (neruina$tickingEntryId != null) {
			output.method_71469("neruina$tickingEntryId", neruina$tickingEntryId.toString());
		}
	}

	@Inject(
			method = "loadAdditional",
			at = @At("TAIL")
	)
	private void readErroredFromNbt(class_11368 input, CallbackInfo ci) {
		neruina$errored = input.method_71433("neruina$errored", false);
		neruina$tickingEntryId = input.method_71441("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
	}
	//?}
}
