/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.thread.ConditionalRunnable;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class MessageHandler {
    public void broadcastToPlayers(MinecraftServer server, class_2561 message, ActionGetter getter) {
        ConditionalRunnable.create(() -> {
            int permissionLevel = Config.minPermissionLevelForMessages;
            if (permissionLevel < 0) {
                return;
            }
            server.method_3760().method_14571().stream().filter(player -> player.method_5687(permissionLevel)).forEach(player -> {
                class_2561 actions = getter.get((class_1657)player);
                player.method_43502(Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, message, actions)), false);
            });
        }, () -> server.method_3760().method_14574() > 0);
    }

    public void broadcastToPlayers(MinecraftServer server, class_2561 message) {
        this.broadcastToPlayers(server, message, p -> Texter.empty());
    }

    public void sendToPlayer(class_1657 player, class_2561 message, class_2561 ... actions) {
        this.sendToPlayer(player, message, true, actions);
    }

    public void sendToPlayer(class_1657 player, class_2561 message, boolean pad, class_2561 ... actions) {
        message = Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(message), actions != null ? Texter.concatDelimited(Texter.LINE_BREAK, actions) : null);
        player.method_7353(pad ? Texter.pad(message) : message, false);
    }

    public class_2561 generateEntityActions(class_1657 forPlayer, class_1297 entity) {
        return Texter.concatDelimited(Texter.SPACE, this.generateHandlingActions(forPlayer, ErroredType.ENTITY, (class_5321<class_1937>)entity.method_37908().method_27983(), entity.method_23312(), entity.method_5667()), this.generateKillAction(forPlayer, entity.method_5667()));
    }

    public class_2561 generateResourceActions(class_1657 forPlayer, TickingEntry entry) {
        return Texter.concatDelimited(Texter.SPACE, this.generateInfoAction(), this.generateCopyCrashAction(entry), this.generateReportAction(forPlayer, entry));
    }

    public class_2561 generateHandlingActions(class_1657 forPlayer, ErroredType type, class_5321<class_1937> dimension, class_2338 pos) {
        return this.generateHandlingActions(forPlayer, type, dimension, pos, null);
    }

    public class_2561 generateHandlingActions(class_1657 forPlayer, ErroredType type, class_5321<class_1937> dimension, class_2338 pos, @Nullable UUID uuid) {
        return Texter.concatDelimited(Texter.SPACE, this.generateTeleportAction(forPlayer, type, dimension, pos), this.generateResumeAction(forPlayer, type, uuid != null ? uuid.toString() : this.posAsNums(pos)));
    }

    public class_2561 generateKillAction(class_1657 forPlayer, UUID uuid) {
        return this.generateCommandAction(forPlayer, "neruina.kill", class_124.field_1079, "/neruina kill %s".formatted(uuid));
    }

    public class_2561 generateCopyCrashAction(TickingEntry entry) {
        StringWriter traceString = new StringWriter();
        PrintWriter writer = new PrintWriter(traceString);
        entry.error().printStackTrace(writer);
        String trace = traceString.toString();
        writer.flush();
        writer.close();
        return this.generateAction("neruina.copy_crash", class_124.field_1065, class_2558.class_2559.field_21462, trace);
    }

    public class_2561 generateReportAction(class_1657 forPlayer, TickingEntry entry) {
        return this.generateCommandAction(forPlayer, "neruina.report", class_124.field_1076, "/neruina report %s".formatted(entry.uuid()));
    }

    public class_2561 generateTeleportAction(class_1657 forPlayer, ErroredType type, class_5321<class_1937> dimension, class_2338 pos) {
        return this.generateCommandAction(forPlayer, "neruina.teleport", "neruina.teleport.%s.tooltip".formatted(type.getName()), class_124.field_1062, "/execute in %s run tp @s %s".formatted(dimension.method_29177().toString(), this.posAsNums(pos)));
    }

    public class_2561 generateInfoAction() {
        return this.generateAction("neruina.info", class_124.field_1060, class_2558.class_2559.field_11749, "https://github.com/Bawnorton/Neruina/wiki/What-Is-This%3F");
    }

    public class_2561 generateResumeAction(class_1657 forPlayer, ErroredType type, String args) {
        return this.generateCommandAction(forPlayer, "neruina.try_resume", "neruina.try_resume.%s.tooltip".formatted(type.getName()), class_124.field_1054, "/neruina resume %s %s".formatted(type.getName(), args));
    }

    public class_2561 generateClearAction(class_1657 forPlayer) {
        return this.generateCommandAction(forPlayer, "neruina.clear", class_124.field_1078, "/neruina clear_tracked");
    }

    public class_2561 generateOpenReportAction(String url) {
        return this.generateAction("neruina.open_report", class_124.field_1076, class_2558.class_2559.field_11749, url);
    }

    public class_2561 generateCancelLoginAction(class_1657 forPlayer) {
        return this.generateCommandAction(forPlayer, "neruina.cancel", class_124.field_1079, "/neruina cancel_login");
    }

    private class_2561 generateCommandAction(class_1657 forPlayer, String key, class_124 color, String command) {
        return this.generateCommandAction(forPlayer, key, "%s.tooltip".formatted(key), color, command);
    }

    private class_2561 generateCommandAction(class_1657 forPlayer, String key, String hoverKey, class_124 color, String command) {
        if (forPlayer.method_5687(Config.minPermissionLevelForCommands.intValue())) {
            return this.generateAction(key, hoverKey, color, class_2558.class_2559.field_11750, command);
        }
        return Texter.empty();
    }

    private class_2561 generateCommandAction(class_1657 forPlayer, class_2561 message, String hoverKey, class_124 color, String command) {
        return this.generateCommandAction(forPlayer, message, Texter.translatable(hoverKey, new Object[0]), color, command);
    }

    private class_2561 generateCommandAction(class_1657 forPlayer, class_2561 message, class_2561 hoverMessage, class_124 color, String command) {
        if (forPlayer.method_5687(Config.minPermissionLevelForCommands.intValue())) {
            return this.generateAction(message, hoverMessage, color, class_2558.class_2559.field_11750, command);
        }
        return Texter.empty();
    }

    private class_2561 generateAction(String key, class_124 color, class_2558.class_2559 action, String value) {
        return this.generateAction(key, "%s.tooltip".formatted(key), color, action, value);
    }

    private class_2561 generateAction(String key, String hoverKey, class_124 color, class_2558.class_2559 action, String value) {
        return this.generateAction(Texter.translatable(key, new Object[0]), Texter.translatable(hoverKey, new Object[0]), color, action, value);
    }

    private class_2561 generateAction(class_2561 message, class_2561 hoverMessage, class_124 color, class_2558.class_2559 action, String value) {
        return class_2564.method_10885((class_2561)Texter.withStyle(message, style -> style.method_10977(color).method_10958(Texter.clickEvent(action, value)).method_10949(Texter.hoverEvent(class_2568.class_5247.field_24342, hoverMessage))));
    }

    public class_2561 generateSuspendedInfo(class_1657 forPlayer) {
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        ArrayList<class_2561> tickingEntryMessages = new ArrayList<class_2561>();
        int count = tickHandler.getTickingEntries().size();
        if (count == 1) {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count.single", new Object[0]));
        } else {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count", count));
        }
        tickHandler.getTickingEntries().forEach(entry -> tickingEntryMessages.add(this.generateCommandAction(forPlayer, Texter.translatable("neruina.ticking_entries.entry", entry.getCauseName(), this.posAsNums(entry.pos())), "neruina.ticking_entries.entry.tooltip", class_124.field_1079, "/neruina info %s".formatted(entry.uuid()))));
        tickingEntryMessages.add(Texter.concatDelimited(Texter.SPACE, this.generateInfoAction(), this.generateClearAction(forPlayer)));
        return Texter.concatDelimited(Texter.LINE_BREAK, tickingEntryMessages.toArray(new class_2561[0]));
    }

    public class_2561 formatText(String key, Object ... args) {
        return Texter.format(Texter.translatable(key, args));
    }

    public String posAsNums(class_2338 pos) {
        return "%s %s %s".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static interface ActionGetter {
        public class_2561 get(class_1657 var1);
    }
}

