/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version;

import com.bawnorton.neruina.Neruina;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public interface Texter {
    public static final class_2561 LINE_BREAK = Texter.literal("\n");
    public static final class_2561 SPACE = Texter.literal(" ");
    public static final class_2561 NERUINA_HEADER = Texter.withStyle(Texter.literal("[Neruina]: "), style -> style.method_10977(class_124.field_1075));
    public static final Map<String, String> FALLBACK_LANG = (Map)class_156.method_654(new HashMap(), map -> {
        try (InputStream langStream = Texter.class.getClassLoader().getResourceAsStream("assets/neruina/lang/en_us.json");){
            if (langStream == null) {
                return;
            }
            class_2477.method_29425((InputStream)langStream, map::put);
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to load default lang from en_us.json", (Throwable)e);
        }
    });

    public static class_2561 literal(String component) {
        return class_2561.method_43470((String)component);
    }

    public static class_2561 translatable(String key, Object ... args) {
        return class_2561.method_48322((String)key, (String)FALLBACK_LANG.getOrDefault(key, key), (Object[])args);
    }

    public static class_2561 empty() {
        return class_2561.method_43473();
    }

    public static class_2561 withStyle(class_2561 component, UnaryOperator<class_2583> style) {
        if (component instanceof class_5250) {
            class_5250 mutableComponent = (class_5250)component;
            mutableComponent.method_27694(style);
        }
        return component;
    }

    public static class_2561 concat(class_2561 ... texts) {
        class_5250 component = class_2561.method_43473();
        for (class_2561 t : texts) {
            if (t.getString().isEmpty()) continue;
            component.method_10852(t);
        }
        return component;
    }

    public static class_2561 concatDelimited(class_2561 delimiter, class_2561 ... texts) {
        class_5250 component = class_2561.method_43473();
        for (int i = 0; i < texts.length; ++i) {
            component.method_10852(texts[i]);
            if (texts[i].getString().isEmpty()) {
                List siblings = component.method_10855();
                if (siblings.isEmpty()) continue;
                siblings.removeLast();
                continue;
            }
            if (i == texts.length - 1) continue;
            component.method_10852(delimiter);
        }
        return component;
    }

    public static class_2561 pad(class_2561 component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        class_5250 padded = class_2561.method_43473();
        padded.method_10852(LINE_BREAK);
        padded.method_10852(component);
        padded.method_10852(LINE_BREAK);
        return padded;
    }

    public static class_2561 format(class_2561 component) {
        if (component.getString().isEmpty()) {
            return component;
        }
        return Texter.concat(NERUINA_HEADER, Texter.withStyle(component, style -> style.method_10977(class_124.field_1061)));
    }

    public static class_2558 clickEvent(class_2558.class_2559 action, String value) {
        return switch (action) {
            case class_2558.class_2559.field_11749 -> new class_2558.class_10608(URI.create(value));
            case class_2558.class_2559.field_11746 -> new class_2558.class_10607(value);
            case class_2558.class_2559.field_11750 -> new class_2558.class_10609(value);
            case class_2558.class_2559.field_11745 -> new class_2558.class_10610(value);
            case class_2558.class_2559.field_21462 -> new class_2558.class_10606(value);
            case class_2558.class_2559.field_11748 -> new class_2558.class_10605(Integer.parseInt(value));
            default -> null;
        };
    }

    public static class_2568 hoverEvent(class_2568.class_5247 action, Object value) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case class_2568.class_5247.field_24342 -> new class_2568.class_10613((class_2561)value);
            case class_2568.class_5247.field_24343 -> new class_2568.class_10612((class_1799)value);
            case class_2568.class_5247.field_24344 -> new class_2568.class_10611((class_2568.class_5248)value);
        };
    }
}

