package com.bawnorton.neruina.mixin;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.TickHandler;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MixinEnvironment
@Mixin(class_3324.class)
public abstract class PlayerListMixin {
    @Inject(
            method = "placeNewPlayer",
            at = @At("TAIL")
    )
    private void sendSuspendedInfoOnJoin(CallbackInfo ci, @Local(argsOnly = true) class_3222 player) {
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        int count = tickHandler.getTickingEntries().size();
        if (count > 0) {
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            class_2561 message = messageHandler.generateSuspendedInfo(player);
            int permissionLevel = Config.minPermissionLevelForMessages;
            if(permissionLevel < 0) return;

            if(player.method_64475(permissionLevel)) {
                player.method_43502(message, false);
            }
        }
    }
}
