package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.util.TickingEntry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PersitanceHandler extends class_18 {
    private static final Codec<PersitanceHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            TickingEntry.CODEC.listOf().fieldOf("tickingEntries").forGetter(PersitanceHandler::getTickingEntries)
    ).apply(
            instance, (tickingEntries -> {
                PersitanceHandler handler = new PersitanceHandler();
                TickHandler tickHandler = Neruina.getInstance().getTickHandler();
                tickingEntries.forEach(tickHandler::addTickingEntryUnsafe);
                return handler;
            })
    ));
    //? if 1.21.1 {
    /*private static final SavedData.Factory<PersitanceHandler> type = new SavedData.Factory<>(
            PersitanceHandler::new,
            (compoundTag, provider) -> load(compoundTag),
            null
    );
    *///?} else {
    private static final class_10741<PersitanceHandler> type = new class_10741<>(
            Neruina.MOD_ID,
            PersitanceHandler::new,
            CODEC,
            null
    );
    //?}

    private static class_3218 level;

    public static void updateServerState(MinecraftServer server) {
        level = server.method_3847(class_1937.field_25179);
        if (level == null) {
            Neruina.LOGGER.error("Level is null, unable to save persistent state.");
            return;
        }
        class_26 dataStorage = level.method_17983();
        //? if 1.21.1 {
        /*PersitanceHandler handler = dataStorage.computeIfAbsent(type, Neruina.MOD_ID);
        *///?} else {
        PersitanceHandler handler = dataStorage.method_17924(type);
        //?}
        handler.method_80();
    }

    public static class_3218 getLevel() {
        return level;
    }

    private List<TickingEntry> getTickingEntries() {
        return Neruina.getInstance()
                .getTickHandler()
                .getTickingEntries()
                .stream()
                .filter(TickingEntry::isPersitent)
                .toList();
    }

    public @NotNull class_2487 save(@NotNull class_2487 tag, class_7225.class_7874 registries) {
        DataResult<class_2520> dataResult = CODEC.encode(this, class_2509.field_11560, tag);
        return (class_2487) dataResult.getOrThrow();
    }

    private static PersitanceHandler load(class_2487 tag) {
        DataResult<PersitanceHandler> dataResult = CODEC.parse(class_2509.field_11560, tag);
        if (dataResult.isSuccess()) {
            return dataResult.getOrThrow();
        } else {
            Neruina.LOGGER.warn("Failed to load persitance handler. {}", dataResult.error().orElseThrow());
            return new PersitanceHandler();
        }
    }
}
