package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@MixinEnvironment
@Mixin(class_1297.class)
public abstract class EntityMixin implements Errorable {
    @Shadow public abstract class_2561 getName();

    @Shadow public abstract class_1937 level();

    @Shadow
    private class_1937 level;
    @Unique
    private boolean neruina$errored = false;

    @Unique
    private UUID neruina$tickingEntryId = null;

    @Override
    public boolean neruina$isErrored() {
        return neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return neruina$tickingEntryId;
    }

    //? if <=1.21.5 {
    /*@Inject(
            method = "saveWithoutId",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"
            )
    )
    private void writeErrored(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        if (neruina$errored) {
            tag.putBoolean("neruina$errored", true);
        }
        if (neruina$tickingEntryId != null) {
            tag.putString("neruina$tickingEntryId", neruina$tickingEntryId.toString());
        }
    }

    @Inject(
            method = "load",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;setAirSupply(I)V"
            )
    )
    private void loadAdditional(CompoundTag tag, CallbackInfo ci) {
        //? if 1.21.1 {
        /^neruina$errored = tag.getBoolean("neruina$errored");
        if (tag.contains("neruina$tickingEntryId")) {
            neruina$tickingEntryId = UUID.fromString(tag.getString("neruina$tickingEntryId"));
        }
        ^///?} else {
        neruina$errored = tag.getBooleanOr("neruina$errored", false);
        neruina$tickingEntryId = tag.getString("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
        //?}
    }
    *///?} else {
    @Inject(
            method = "saveWithoutId",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"
            )
    )
    private void writeErroredToNbt(class_11372 output, CallbackInfo ci) {
        if (neruina$errored) {
            output.method_71472("neruina$errored", true);
        }
        if (neruina$tickingEntryId != null) {
            output.method_71469("neruina$tickingEntryId", neruina$tickingEntryId.toString());
        }
    }

    @Inject(
            method = "load",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;setAirSupply(I)V"
            )
    )
    private void readErroredFromNbt(class_11368 input, CallbackInfo ci) {
        neruina$errored = input.method_71433("neruina$errored", false);
        neruina$tickingEntryId = input.method_71441("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
    }
    //?}

    @ModifyReturnValue(
            method = {
                    "isInvulnerableTo",
                    "method_64421",
                    "isInvulnerableToBase"
            },
            at = @At("RETURN")
    )
    private boolean ignoreDamageWhenErrored(boolean original, @Local(argsOnly = true) class_1282 source) {
        if (original) return true;

        if (neruina$errored && neruina$tickingEntryId != null) {
            if (source.method_5529() instanceof class_3222 player) {
                TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(neruina$tickingEntryId);
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                if(entry == null) {
                    messageHandler.sendToPlayer(
                            player,
                            Texter.concatDelimited(
                                    Texter.LINE_BREAK,
                                    Texter.translatable("neruina.suspended.entity", getName().getString()),
                                    Texter.translatable("neruina.suspended.entity.untracked")
                            ),
                            messageHandler.generateEntityActions(player, (class_1297) (Object) this),
                            messageHandler.generateInfoAction()
                    );
                } else {
                    messageHandler.sendToPlayer(
                            player,
                            Texter.translatable("neruina.suspended.entity", getName().getString()),
                            messageHandler.generateEntityActions(player, (class_1297) (Object) this),
                            messageHandler.generateResourceActions(player, entry)
                    );
                }
            }
            return source != level.method_48963().method_51847();
        }
        return false;
    }
}
