package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

@MixinEnvironment
@Mixin(class_1799.class)
public abstract class ItemStackMixin implements Errorable {
	@Shadow
	@Final
	class_9335 components;

	@Unique
	private boolean neruina$errored = false;

	@Unique
	private UUID neruina$tickingEntryId = null;

	@Override
	public boolean neruina$isErrored() {
		return neruina$errored;
	}

	@Override
	public void neruina$setErrored() {
		neruina$errored = true;
		neruina$updateData();
	}

	@Override
	public void neruina$clearErrored() {
		neruina$errored = false;
		neruina$updateData();
	}

	@Override
	public void neruina$setTickingEntryId(UUID uuid) {
		neruina$tickingEntryId = uuid;
		neruina$updateData();
	}

	@Override
	public UUID neruina$getTickingEntryId() {
		return neruina$tickingEntryId;
	}

	@Unique
	private void neruina$updateData() {
		class_2487 tag = new class_2487();
		if (neruina$errored) {
			tag.method_10556("neruina$errored", true);
		}
		if (neruina$tickingEntryId != null) {
			tag.method_10582("neruina$tickingEntryId", neruina$tickingEntryId.toString());
		}
		class_9279 data = class_9279.method_57456(tag);
		class_9326.class_9327 builder = class_9326.method_57841()
				.method_57854(class_9334.field_49628, data);
		components.method_57936(builder.method_57852());
	}

	@Inject(method = "<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V", at = @At("TAIL"))
	private void readErroredFromComponents(class_1935 item, int count, class_9335 components, CallbackInfo ci) {
		class_9279 data = components.method_58694(class_9334.field_49628);
		if (data == null) return;

		class_2487 tag = data.method_57461();
		//? if 1.21.1 {
        /*neruina$errored = tag.getBoolean("neruina$errored");
        if (tag.contains("neruina$tickingEntryId")) {
            neruina$tickingEntryId = tag.getUUID("neruina$tickingEntryId");
        }
        *///?} else {
		neruina$errored = tag.method_68566("neruina$errored", false);
		neruina$tickingEntryId = tag.method_10558("neruina$tickingEntryId").map(UUID::fromString).orElse(null);
		//?}
	}
}