#ifdef FSH

varying vec2 texCoord;
varying vec4 vertexColor;

uniform sampler2D texture;

void main() {
    vec4 albedo = texture2D(texture, texCoord);

    gl_FragColor = vec4(1.0 - albedo.rgb * vertexColor.rgb, albedo.a * vertexColor.a);
}

#endif

#ifdef VSH

varying vec2 texCoord;
varying vec4 vertexColor;

void main() {
    texCoord = gl_MultiTexCoord0.xy;
    vertexColor = gl_Color;

    gl_Position = ftransform();
}

#endif