#ifdef FSH

varying vec2 texCoord;

uniform sampler2D skyTexture;

void main() {
    vec4 skyColor = texture2D(skyTexture, texCoord);

    vec3 invSun = vec3(1.0) - clamp(skyColor.rgb, 0.0, 1.0);

    gl_FragColor = vec4(skyColor.rgb * invSun, skyColor.a);
}

#endif

#ifdef VSH

varying vec2 texCoord;

void main() {
    texCoord = gl_MultiTexCoord0.xy;

    gl_Position = ftransform();
}

#endif