/*
 * Decompiled with CFR 0.152.
 */
package vault.mamtak.privateVaults;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;

public final class PrivateVaults
extends JavaPlugin
implements Listener,
TabCompleter {
    private File vaultsFolder;
    private final Map<UUID, Map<Integer, Inventory>> openVaultsByOwner = new HashMap<UUID, Map<Integer, Inventory>>();
    private final Map<Inventory, UUID> openVaultOwners = new HashMap<Inventory, UUID>();
    private final Map<Inventory, Integer> openVaultNumbers = new HashMap<Inventory, Integer>();
    private final Map<Inventory, Set<UUID>> inventoryViewers = new HashMap<Inventory, Set<UUID>>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.vaultsFolder = new File(this.getDataFolder(), "vaults");
        if (!this.vaultsFolder.exists()) {
            this.vaultsFolder.mkdirs();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("pv")).setTabCompleter((TabCompleter)this);
    }

    public void onDisable() {
        for (Inventory inv : new ArrayList<Inventory>(this.openVaultOwners.keySet())) {
            this.saveVault(inv);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (sender.isOp()) {
                this.reloadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded.");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only operators can reload.");
            }
            return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("list")) {
            Player target;
            if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can list their vaults.");
                    return true;
                }
                target = (Player)sender;
            } else {
                if (!sender.hasPermission("mamtak.pv.adminaccess")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission to list others' vaults.");
                    return true;
                }
                target = Bukkit.getPlayerExact((String)args[1]);
                if (target == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
            }
            this.listVaults(sender, target);
            return true;
        }
        if (args.length >= 1) {
            UUID ownerUuid;
            Player viewer;
            int vaultNumber;
            try {
                vaultNumber = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid vault number.");
                return true;
            }
            if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can open vaults.");
                    return true;
                }
                viewer = (Player)sender;
                ownerUuid = viewer.getUniqueId();
                int max = this.determineMaxVaults(viewer);
                if (vaultNumber < 1 || vaultNumber > max) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don\u2019t have access to that vault.");
                    return true;
                }
            } else {
                if (!sender.hasPermission("mamtak.pv.adminaccess")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission to open others' vaults.");
                    return true;
                }
                viewer = sender instanceof Player ? (Player)sender : null;
                Player target = Bukkit.getPlayerExact((String)args[1]);
                if (target == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                ownerUuid = target.getUniqueId();
                int max = this.determineMaxVaults(target);
                if (vaultNumber < 1 || vaultNumber > max) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " doesn\u2019t have that vault.");
                    return true;
                }
            }
            this.openVault(viewer, ownerUuid, vaultNumber);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /pv <number> [player] | /pv list [player] | /pv reload");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("pv")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.filter(Arrays.asList("reload", "list"), args[0]);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("list") || this.isNumeric(args[0]))) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                players.add(p.getName());
            }
            return this.filter(players, args[1]);
        }
        return Collections.emptyList();
    }

    private List<String> filter(List<String> list, String token) {
        ArrayList<String> result = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)token, list, result);
        Collections.sort(result);
        return result;
    }

    private boolean isNumeric(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void listVaults(CommandSender sender, Player target) {
        int max = this.determineMaxVaults(target);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= max; ++i) {
            sb.append(i).append(", ");
        }
        if (sb.length() >= 2) {
            sb.setLength(sb.length() - 2);
        }
        String header = String.valueOf(ChatColor.GOLD) + (String)(sender.equals((Object)target) ? "Your vaults: " : target.getName() + "'s vaults: ");
        sender.sendMessage(header + String.valueOf(ChatColor.GREEN) + String.valueOf(sb));
    }

    private int determineMaxVaults(Player player) {
        int max = this.getConfig().getInt("vault-limits.normal", 2);
        if (player.hasPermission("mamtak.pv.advanced")) {
            max = Math.max(max, this.getConfig().getInt("vault-limits.advanced", 4));
        }
        if (player.hasPermission("mamtak.pv.rich")) {
            max = Math.max(max, this.getConfig().getInt("vault-limits.rich", 6));
        }
        if (player.hasPermission("mamtak.pv.moderator")) {
            max = Math.max(max, this.getConfig().getInt("vault-limits.moderator", 8));
        }
        if (player.hasPermission("mamtak.pv.admin")) {
            max = Math.max(max, this.getConfig().getInt("vault-limits.admin", 12));
        }
        if (player.hasPermission("mamtak.pv.owner")) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    private int getVaultSize(int vaultNumber) {
        int size = this.getConfig().getInt("vault-sizes." + vaultNumber, this.getConfig().getInt("default-vault-size", 32));
        if ((size = Math.max(9, Math.min(54, size))) % 9 != 0) {
            size = (size / 9 + 1) * 9;
        }
        return size;
    }

    private Inventory getOrCreateVault(UUID ownerUuid, int vaultNumber) {
        Map byNumber = this.openVaultsByOwner.computeIfAbsent(ownerUuid, k -> new HashMap());
        if (byNumber.containsKey(vaultNumber)) {
            return (Inventory)byNumber.get(vaultNumber);
        }
        int size = this.getVaultSize(vaultNumber);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.GREEN) + "Vault " + vaultNumber));
        File vaultFile = new File(this.vaultsFolder, String.valueOf(ownerUuid) + "_" + vaultNumber + ".yml");
        YamlConfiguration vcfg = YamlConfiguration.loadConfiguration((File)vaultFile);
        for (int i = 0; i < size; ++i) {
            ItemStack item = vcfg.getItemStack("slot." + i);
            if (item == null) continue;
            inv.setItem(i, item);
        }
        byNumber.put(vaultNumber, inv);
        this.openVaultOwners.put(inv, ownerUuid);
        this.openVaultNumbers.put(inv, vaultNumber);
        return inv;
    }

    private void openVault(Player viewer, UUID ownerUuid, int vaultNumber) {
        Inventory inv = this.getOrCreateVault(ownerUuid, vaultNumber);
        if (viewer != null) {
            this.inventoryViewers.computeIfAbsent(inv, k -> new HashSet()).add(viewer.getUniqueId());
            viewer.openInventory(inv);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        if (!this.inventoryViewers.containsKey(inv)) {
            return;
        }
        UUID uid = event.getPlayer().getUniqueId();
        Set<UUID> viewers = this.inventoryViewers.get(inv);
        viewers.remove(uid);
        if (viewers.isEmpty()) {
            this.saveVault(inv);
            this.inventoryViewers.remove(inv);
            UUID owner = this.openVaultOwners.remove(inv);
            int num = this.openVaultNumbers.remove(inv);
            Map<Integer, Inventory> byNumber = this.openVaultsByOwner.get(owner);
            if (byNumber != null) {
                byNumber.remove(num);
                if (byNumber.isEmpty()) {
                    this.openVaultsByOwner.remove(owner);
                }
            }
        }
    }

    private void saveVault(Inventory inv) {
        UUID owner = this.openVaultOwners.get(inv);
        int number = this.openVaultNumbers.get(inv);
        File vaultFile = new File(this.vaultsFolder, String.valueOf(owner) + "_" + number + ".yml");
        YamlConfiguration vcfg = new YamlConfiguration();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null) continue;
            vcfg.set("slot." + i, (Object)item);
        }
        try {
            vcfg.save(vaultFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save vault " + String.valueOf(owner) + "_" + number);
            e.printStackTrace();
        }
    }
}

