package mod.bespectacled.modernbetaforge.client.gui;

import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiCustomizePreset;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiCustomizePresets {
    public static final ResourceLocation CLASSIC_BETA = ModernBeta.createRegistryKey("classic_beta");
    public static final ResourceLocation CLASSIC_ALPHA_1_2 = ModernBeta.createRegistryKey("classic_alpha_1_2");
    public static final ResourceLocation CLASSIC_ALPHA = ModernBeta.createRegistryKey("classic_alpha");
    public static final ResourceLocation CLASSIC_ALPHA_WINTER = ModernBeta.createRegistryKey("classic_alpha_winter");
    public static final ResourceLocation CLASSIC_INFDEV_611 = ModernBeta.createRegistryKey("classic_infdev_611");
    public static final ResourceLocation CLASSIC_INFDEV_420 = ModernBeta.createRegistryKey("classic_infdev_420");
    public static final ResourceLocation CLASSIC_INFDEV_415 = ModernBeta.createRegistryKey("classic_infdev_415");
    public static final ResourceLocation CLASSIC_INFDEV_227 = ModernBeta.createRegistryKey("classic_infdev_227");
    public static final ResourceLocation CLASSIC_INDEV_ISLAND = ModernBeta.createRegistryKey("classic_indev_island");
    public static final ResourceLocation CLASSIC_0_0_23A = ModernBeta.createRegistryKey("classic_0_0_23a");
    public static final ResourceLocation CLASSIC_SKYLANDS = ModernBeta.createRegistryKey("classic_skylands");
    public static final ResourceLocation BETA_SKYLANDS = ModernBeta.createRegistryKey("beta_skylands");
    public static final ResourceLocation BETA_PE = ModernBeta.createRegistryKey("beta_pe");
    public static final ResourceLocation BETA_REALISTIC = ModernBeta.createRegistryKey("beta_realistic");
    public static final ResourceLocation BETA_PLUS = ModernBeta.createRegistryKey("beta_plus");
    public static final ResourceLocation BETA_RELEASE = ModernBeta.createRegistryKey("beta_release");
    public static final ResourceLocation BETA_END = ModernBeta.createRegistryKey("beta_end");
    public static final ResourceLocation DEBUG_NOISE = ModernBeta.createRegistryKey("debug_noise");
    
    public static final String SETTINGS_CLASSIC_BETA = "{\"chunkSource\":\"modernbetaforge:beta\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"minecraft:plains\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":true,\"useNewFlowers\":false,\"useDoublePlants\":false,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":false,\"spawnWolves\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_ALPHA_1_2 = "{\"chunkSource\":\"modernbetaforge:beta\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:alpha_1_2\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"minecraft:plains\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":false,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_ALPHA = "{\"chunkSource\":\"modernbetaforge:alpha\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:alpha\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"modernbetaforge:alpha\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.0,\"scaleNoiseScaleZ\":1.0,\"depthNoiseScaleX\":100.0,\"depthNoiseScaleZ\":100.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}";
    public static final String SETTINGS_CLASSIC_ALPHA_WINTER = "{\"chunkSource\":\"modernbetaforge:alpha\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:alpha\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"modernbetaforge:alpha_winter\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.0,\"scaleNoiseScaleZ\":1.0,\"depthNoiseScaleX\":100.0,\"depthNoiseScaleZ\":100.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_INFDEV_611 = "{\"chunkSource\":\"modernbetaforge:infdev_611\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:infdev\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"modernbetaforge:infdev_611\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.0,\"scaleNoiseScaleZ\":1.0,\"depthNoiseScaleX\":100.0,\"depthNoiseScaleZ\":100.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":16,\"ironCount\":10,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":16,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":16,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_INFDEV_420 = "{\"chunkSource\":\"modernbetaforge:infdev_420\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:infdev\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:infdev\",\"singleBiome\":\"modernbetaforge:infdev_420\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":16,\"ironCount\":10,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":16,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":16,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_INFDEV_415 = "{\"chunkSource\":\"modernbetaforge:infdev_415\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:infdev\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:infdev\",\"singleBiome\":\"modernbetaforge:infdev_415\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":984.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":400.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":16,\"ironCount\":10,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":16,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":16,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_INFDEV_227 = "{\"chunkSource\":\"modernbetaforge:infdev_227\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:infdev_227\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:infdev\",\"singleBiome\":\"modernbetaforge:infdev_227\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":false,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":96,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":0,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":0,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":0,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":0,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":false,\"useNewFlowers\":true,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_INDEV_ISLAND = "{\"chunkSource\":\"modernbetaforge:indev\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"modernbetaforge:indev_normal\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":10,\"coalMinHeight\":0,\"coalMaxHeight\":51,\"ironSize\":8,\"ironCount\":8,\"ironMinHeight\":0,\"ironMaxHeight\":38,\"goldSize\":8,\"goldCount\":5,\"goldMinHeight\":0,\"goldMaxHeight\":26,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":8,\"diamondMinHeight\":0,\"diamondMaxHeight\":13,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":true,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_0_0_23A = "{\"chunkSource\":\"modernbetaforge:classic_0_0_23a\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"modernbetaforge:indev_normal\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":false,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"none\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":0,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":0,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":0,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":9,\"coalMinHeight\":0,\"coalMaxHeight\":64,\"ironSize\":16,\"ironCount\":7,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":16,\"goldCount\":5,\"goldMinHeight\":0,\"goldMaxHeight\":64,\"redstoneSize\":7,\"redstoneCount\":0,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":0,\"diamondMinHeight\":0,\"diamondMaxHeight\":13,\"lapisSize\":6,\"lapisCount\":0,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":true,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_CLASSIC_SKYLANDS = "{\"chunkSource\":\"modernbetaforge:skylands\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:default\",\"singleBiome\":\"modernbetaforge:beta_sky\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"replaceRiverBiomes\":true,\"coordinateScale\":1368.824,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":0,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"useAmplified\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":false,\"useVillages\":false,\"useVillageVariants\":false,\"useMineShafts\":false,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":true,\"useNetherCaves\":true,\"useFortresses\":false,\"useLavaPockets\":false,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"oreType\":\"classic\",\"claySize\":32,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":32,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":32,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":32,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":32,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":32,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":16,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":8,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":8,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":7,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":7,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":6,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":2,\"emeraldCount\":0,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":0,\"magmaSize\":33,\"magmaCount\":0,\"useTallGrass\":false,\"useNewFlowers\":false,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":false,\"useDesertWells\":false,\"useFossils\":false,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":false,\"usePineTrees\":false,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":false,\"spawnNewMonsterMobs\":false,\"spawnWaterMobs\":false,\"spawnAmbientMobs\":false,\"spawnWolves\":false,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}"; 
    public static final String SETTINGS_BETA_SKYLANDS = "{\"chunkSource\":\"modernbetaforge:skylands\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:default\",\"singleBiome\":\"minecraft:plains\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"coordinateScale\":1368.824,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":0,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":48,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"useModdedBiomes\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\"}";
    public static final String SETTINGS_BETA_PE = "{\"chunkSource\":\"modernbetaforge:pe\",\"biomeSource\":\"modernbetaforge:pe\",\"surfaceBuilder\":\"modernbetaforge:pe\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:pe\",\"singleBiome\":\"minecraft:plains\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":false,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"useModdedBiomes\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\"}";
    public static final String SETTINGS_BETA_REALISTIC = "{\"chunkSource\":\"modernbetaforge:beta\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta_1_8\",\"singleBiome\":\"minecraft:plains\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"coordinateScale\":171.103,\"heightScale\":342.206,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":100.0,\"depthNoiseScaleZ\":100.0,\"mainNoiseScaleX\":5000.0,\"mainNoiseScaleY\":1000.0,\"mainNoiseScaleZ\":5000.0,\"baseSize\":7.0,\"stretchY\":2.5,\"seaLevel\":64,\"height\":255,\"tempNoiseScale\":8.0,\"rainNoiseScale\":8.0,\"detailNoiseScale\":4.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"caveWidth\":2.5,\"caveHeight\":255,\"caveCount\":80,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":40,\"dirtMinHeight\":0,\"dirtMaxHeight\":255,\"gravelSize\":33,\"gravelCount\":20,\"gravelMinHeight\":0,\"gravelMaxHeight\":255,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":40,\"coalMinHeight\":0,\"coalMaxHeight\":255,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":255,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"useModdedBiomes\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\"}";
    public static final String SETTINGS_BETA_PLUS = "{\"chunkSource\":\"modernbetaforge:beta\",\"biomeSource\":\"modernbetaforge:release\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:beta\",\"singleBiome\":\"minecraft:plains\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":63,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":true,\"useUnderwaterCaves\":false,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useDoublePlants\":true,\"useLilyPads\":true,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":true,\"useJungleTrees\":true,\"useAcaciaTrees\":true,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"desertBiomeBase\":\"minecraft:desert\",\"desertBiomeOcean\":\"minecraft:ocean\",\"desertBiomeBeach\":\"minecraft:desert\",\"forestBiomeBase\":\"minecraft:forest\",\"forestBiomeOcean\":\"minecraft:ocean\",\"forestBiomeBeach\":\"minecraft:beaches\",\"iceDesertBiomeBase\":\"minecraft:ice_flats\",\"iceDesertBiomeOcean\":\"minecraft:frozen_ocean\",\"iceDesertBiomeBeach\":\"minecraft:cold_beach\",\"plainsBiomeBase\":\"minecraft:plains\",\"plainsBiomeOcean\":\"minecraft:ocean\",\"plainsBiomeBeach\":\"minecraft:beaches\",\"rainforestBiomeBase\":\"minecraft:jungle\",\"rainforestBiomeOcean\":\"minecraft:ocean\",\"rainforestBiomeBeach\":\"minecraft:beaches\",\"savannaBiomeBase\":\"minecraft:savanna\",\"savannaBiomeOcean\":\"minecraft:ocean\",\"savannaBiomeBeach\":\"minecraft:beaches\",\"shrublandBiomeBase\":\"minecraft:plains\",\"shrublandBiomeOcean\":\"minecraft:ocean\",\"shrublandBiomeBeach\":\"minecraft:beaches\",\"seasonalForestBiomeBase\":\"minecraft:roofed_forest\",\"seasonalForestBiomeOcean\":\"minecraft:ocean\",\"seasonalForestBiomeBeach\":\"minecraft:beaches\",\"swamplandBiomeBase\":\"minecraft:swampland\",\"swamplandBiomeOcean\":\"minecraft:ocean\",\"swamplandBiomeBeach\":\"minecraft:swampland\",\"taigaBiomeBase\":\"minecraft:taiga_cold\",\"taigaBiomeOcean\":\"minecraft:frozen_ocean\",\"taigaBiomeBeach\":\"minecraft:cold_beach\",\"tundraBiomeBase\":\"minecraft:ice_flats\",\"tundraBiomeOcean\":\"minecraft:frozen_ocean\",\"tundraBiomeBeach\":\"minecraft:cold_beach\"}";
    public static final String SETTINGS_BETA_RELEASE = "{\"chunkSource\":\"modernbetaforge:release\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"singleBiome\":\"minecraft:plains\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"depthNoiseScaleExponent\":0.5,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":63,\"height\":255,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":true,\"useCaves\":true,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"useSandstone\":true,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"useTallGrass\":true,\"useNewFlowers\":true,\"useLilyPads\":true,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":true,\"useJungleTrees\":true,\"useAcaciaTrees\":true,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\"}";
    public static final String SETTINGS_BETA_END = "{\"chunkSource\":\"modernbetaforge:end\",\"biomeSource\":\"modernbetaforge:beta\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:beta\",\"worldSpawner\":\"modernbetaforge:default\",\"singleBiome\":\"minecraft:plains\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":false,\"replaceBeachBiomes\":false,\"coordinateScale\":1368.824,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":0,\"height\":128,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":false,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":false,\"useMonuments\":false,\"useMansions\":false,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":0,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":0,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":0,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"useModdedBiomes\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\"}";
    public static final String SETTINGS_DEBUG_NOISE = "{\"chunkSource\":\"modernbetaforge:debug_noise\",\"biomeSource\":\"modernbetaforge:single\",\"surfaceBuilder\":\"modernbetaforge:beta\",\"caveCarver\":\"modernbetaforge:none\",\"worldSpawner\":\"modernbetaforge:infdev\",\"singleBiome\":\"modernbetaforge:beta_shrubland\",\"defaultBlock\":\"minecraft:stone\",\"defaultFluid\":\"minecraft:water\",\"replaceOceanBiomes\":true,\"replaceBeachBiomes\":true,\"replaceRiverBiomes\":true,\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"scaleNoiseScaleX\":1.121,\"scaleNoiseScaleZ\":1.121,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"seaLevel\":64,\"height\":255,\"tempNoiseScale\":1.0,\"rainNoiseScale\":1.0,\"detailNoiseScale\":1.0,\"snowLineOffset\":64,\"useClimateFeatures\":true,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"useBiomeDepthScale\":true,\"biomeSize\":4,\"riverSize\":4,\"layerType\":\"vanilla\",\"layerSize\":4,\"layerVersion\":1700,\"snowyBiomeChance\":8,\"endIslandOffset\":100.0,\"endIslandWeight\":8.0,\"endOuterIslandOffset\":100.0,\"endOuterIslandDistance\":64,\"useEndOuterIslands\":true,\"caveWidth\":1.0,\"caveHeight\":128,\"caveCount\":40,\"caveChance\":15,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useVillageVariants\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useMansions\":true,\"useRavines\":false,\"useUnderwaterCaves\":false,\"useWaterLakes\":false,\"waterLakeChance\":4,\"useLavaLakes\":false,\"lavaLakeChance\":80,\"useSandstone\":true,\"useOldNether\":false,\"useNetherCaves\":true,\"useFortresses\":true,\"useLavaPockets\":true,\"useInfdevWalls\":true,\"useInfdevPyramids\":true,\"levelTheme\":\"normal\",\"levelType\":\"island\",\"levelWidth\":256,\"levelLength\":256,\"levelHeight\":64,\"levelHouse\":\"oak\",\"useIndevCaves\":true,\"levelCaveWidth\":1.0,\"claySize\":33,\"clayCount\":10,\"clayMinHeight\":0,\"clayMaxHeight\":128,\"dirtSize\":33,\"dirtCount\":20,\"dirtMinHeight\":0,\"dirtMaxHeight\":128,\"gravelSize\":33,\"gravelCount\":10,\"gravelMinHeight\":0,\"gravelMaxHeight\":128,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16,\"emeraldSize\":3,\"emeraldCount\":1,\"emeraldMinHeight\":95,\"emeraldMaxHeight\":128,\"quartzSize\":14,\"quartzCount\":16,\"magmaSize\":33,\"magmaCount\":4,\"useTallGrass\":true,\"useNewFlowers\":true,\"useDoublePlants\":true,\"useLilyPads\":false,\"useMelons\":true,\"useDesertWells\":true,\"useFossils\":true,\"useSandDisks\":false,\"useGravelDisks\":false,\"useClayDisks\":false,\"useBirchTrees\":true,\"usePineTrees\":true,\"useSwampTrees\":false,\"useJungleTrees\":false,\"useAcaciaTrees\":false,\"useNewFancyOakTrees\":false,\"spawnNewCreatureMobs\":true,\"spawnNewMonsterMobs\":true,\"spawnWaterMobs\":true,\"spawnAmbientMobs\":true,\"spawnWolves\":true,\"desertBiomeBase\":\"modernbetaforge:beta_desert\",\"desertBiomeOcean\":\"modernbetaforge:beta_ocean\",\"desertBiomeBeach\":\"modernbetaforge:beta_desert\",\"forestBiomeBase\":\"modernbetaforge:beta_forest\",\"forestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"forestBiomeBeach\":\"modernbetaforge:beta_beach\",\"iceDesertBiomeBase\":\"modernbetaforge:beta_tundra\",\"iceDesertBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"iceDesertBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"plainsBiomeBase\":\"modernbetaforge:beta_plains\",\"plainsBiomeOcean\":\"modernbetaforge:beta_ocean\",\"plainsBiomeBeach\":\"modernbetaforge:beta_beach\",\"rainforestBiomeBase\":\"modernbetaforge:beta_rainforest\",\"rainforestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"rainforestBiomeBeach\":\"modernbetaforge:beta_beach\",\"savannaBiomeBase\":\"modernbetaforge:beta_savanna\",\"savannaBiomeOcean\":\"modernbetaforge:beta_ocean\",\"savannaBiomeBeach\":\"modernbetaforge:beta_beach\",\"shrublandBiomeBase\":\"modernbetaforge:beta_shrubland\",\"shrublandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"shrublandBiomeBeach\":\"modernbetaforge:beta_beach\",\"seasonalForestBiomeBase\":\"modernbetaforge:beta_seasonal_forest\",\"seasonalForestBiomeOcean\":\"modernbetaforge:beta_ocean\",\"seasonalForestBiomeBeach\":\"modernbetaforge:beta_beach\",\"swamplandBiomeBase\":\"modernbetaforge:beta_swampland\",\"swamplandBiomeOcean\":\"modernbetaforge:beta_ocean\",\"swamplandBiomeBeach\":\"modernbetaforge:beta_beach\",\"taigaBiomeBase\":\"modernbetaforge:beta_taiga\",\"taigaBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"taigaBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"tundraBiomeBase\":\"modernbetaforge:beta_tundra\",\"tundraBiomeOcean\":\"modernbetaforge:beta_frozen_ocean\",\"tundraBiomeBeach\":\"modernbetaforge:beta_snowy_beach\",\"compatbiomesoplenty:usecompat\":true}";
    
    public static final GuiCustomizePreset PRESET_CLASSIC_BETA = new GuiCustomizePreset(SETTINGS_CLASSIC_BETA);
    public static final GuiCustomizePreset PRESET_CLASSIC_ALPHA_1_2 = new GuiCustomizePreset(SETTINGS_CLASSIC_ALPHA_1_2);
    public static final GuiCustomizePreset PRESET_CLASSIC_ALPHA = new GuiCustomizePreset(SETTINGS_CLASSIC_ALPHA);
    public static final GuiCustomizePreset PRESET_CLASSIC_ALPHA_WINTER = new GuiCustomizePreset(SETTINGS_CLASSIC_ALPHA_WINTER);
    public static final GuiCustomizePreset PRESET_CLASSIC_INFDEV_611 = new GuiCustomizePreset(SETTINGS_CLASSIC_INFDEV_611);
    public static final GuiCustomizePreset PRESET_CLASSIC_INFDEV_420 = new GuiCustomizePreset(SETTINGS_CLASSIC_INFDEV_420);
    public static final GuiCustomizePreset PRESET_CLASSIC_INFDEV_415 = new GuiCustomizePreset(SETTINGS_CLASSIC_INFDEV_415);
    public static final GuiCustomizePreset PRESET_CLASSIC_INFDEV_227 = new GuiCustomizePreset(SETTINGS_CLASSIC_INFDEV_227);
    public static final GuiCustomizePreset PRESET_CLASSIC_INDEV_ISLAND = new GuiCustomizePreset(SETTINGS_CLASSIC_INDEV_ISLAND);
    public static final GuiCustomizePreset PRESET_CLASSIC_0_0_23A = new GuiCustomizePreset(SETTINGS_CLASSIC_0_0_23A);
    public static final GuiCustomizePreset PRESET_CLASSIC_SKYLANDS = new GuiCustomizePreset(SETTINGS_CLASSIC_SKYLANDS);
    public static final GuiCustomizePreset PRESET_BETA_SKYLANDS = new GuiCustomizePreset(SETTINGS_BETA_SKYLANDS);
    public static final GuiCustomizePreset PRESET_BETA_PE = new GuiCustomizePreset(SETTINGS_BETA_PE);
    public static final GuiCustomizePreset PRESET_BETA_REALISTIC = new GuiCustomizePreset(SETTINGS_BETA_REALISTIC);
    public static final GuiCustomizePreset PRESET_BETA_PLUS = new GuiCustomizePreset(SETTINGS_BETA_PLUS);
    public static final GuiCustomizePreset PRESET_BETA_RELEASE = new GuiCustomizePreset(SETTINGS_BETA_RELEASE);
    public static final GuiCustomizePreset PRESET_BETA_END = new GuiCustomizePreset(SETTINGS_BETA_END);
    public static final GuiCustomizePreset PRESET_DEBUG_NOISE = new GuiCustomizePreset(SETTINGS_DEBUG_NOISE);
}

