/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.registry;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class ModernBetaModRegistry {
    public static final ModernBetaModRegistry INSTANCE = new ModernBetaModRegistry();
    private final Map<String, Integer> registryEntries = new LinkedHashMap<String, Integer>();

    private ModernBetaModRegistry() {
    }

    public void register(String modId, int dataVersion) {
        if (this.contains(modId)) {
            throw new IllegalArgumentException("[Modern Beta] Mod registry already contains entry named " + modId);
        }
        this.registryEntries.put(modId, dataVersion);
    }

    public int getDataVersion(String modId) {
        if (!this.contains(modId)) {
            throw new NoSuchElementException("[Modern Beta] Mod registry does not contain entry named " + modId);
        }
        return this.registryEntries.get(modId);
    }

    public boolean contains(String modId) {
        return this.registryEntries.containsKey(modId);
    }

    public List<Map.Entry<String, Integer>> getEntries() {
        return this.registryEntries.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}

