/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.data;

import com.google.common.collect.BiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class FiniteDataHandler {
    public static final String FILE_NAME = "mblevel.dat";
    private static final int FINITE_VERSION_V1_3_1_0 = 1310;
    private final File worldDirectory;
    private FiniteData finiteData;

    public FiniteDataHandler(World world, FiniteChunkSource finiteChunkSource) {
        this.worldDirectory = world.func_72860_G().func_75765_b();
        this.finiteData = new FiniteData(finiteChunkSource.getLevelWidth(), finiteChunkSource.getLevelHeight(), finiteChunkSource.getLevelLength());
    }

    public boolean writeLevelData(byte[] levelData, BiMap<Byte, String> levelMap) {
        boolean saved = false;
        this.finiteData.setLevelData(levelData, (BiMap<Byte, String>)levelMap);
        try (FileOutputStream fos = new FileOutputStream(new File(this.worldDirectory, FILE_NAME));
             GZIPOutputStream gos = new GZIPOutputStream(fos);
             ObjectOutputStream oos = new ObjectOutputStream(gos);){
            oos.writeObject(this.finiteData);
            saved = true;
        }
        catch (Exception e) {
            ModernBeta.log(Level.ERROR, String.format("Level file '%s' couldn't be saved!", FILE_NAME));
            ModernBeta.log(Level.ERROR, "Error: " + e.getMessage());
        }
        return saved;
    }

    public FiniteChunkSource.LevelDataContainer readLevelData(int levelWidth, int levelHeight, int levelLength) {
        FiniteChunkSource.LevelDataContainer levelDataContainer;
        try (FileInputStream fis = new FileInputStream(new File(this.worldDirectory, FILE_NAME));
             GZIPInputStream gis = new GZIPInputStream(fis);
             ObjectInputStream ois = new ObjectInputStream(gis);){
            this.finiteData = (FiniteData)ois.readObject();
            levelDataContainer = this.finiteData.getLevelData(levelWidth, levelHeight, levelLength);
        }
        catch (Exception e) {
            levelDataContainer = new FiniteChunkSource.LevelDataContainer(levelWidth, levelHeight, levelLength);
            ModernBeta.log(Level.WARN, String.format("Level file '%s' is missing or corrupted and couldn't be loaded. Level will be generated and then saved!", FILE_NAME));
            ModernBeta.log(Level.WARN, "Error: " + e.getMessage());
        }
        return levelDataContainer;
    }

    private static int getFiniteVersion() {
        return 1310;
    }

    private static class FiniteData
    implements Serializable {
        private static final long serialVersionUID = 4163598858586006355L;
        private final int levelVersion = FiniteDataHandler.access$300();
        private final int levelWidth;
        private final int levelHeight;
        private final int levelLength;
        private byte[] levelData;
        private BiMap<Byte, String> levelMap;

        private FiniteData(int levelWidth, int levelHeight, int levelLength) {
            this.levelWidth = levelWidth;
            this.levelHeight = levelHeight;
            this.levelLength = levelLength;
        }

        private void setLevelData(byte[] levelData, BiMap<Byte, String> levelMap) {
            this.levelData = levelData;
            this.levelMap = levelMap;
            ModernBeta.log(Level.DEBUG, String.format("Packed byte array of size %d", this.levelData.length));
            ModernBeta.log(Level.DEBUG, String.format("Packed block map of size %d", this.levelMap.size()));
        }

        private FiniteChunkSource.LevelDataContainer getLevelData(int levelWidth, int levelHeight, int levelLength) throws IllegalStateException, NullPointerException {
            if (this.levelVersion < FiniteDataHandler.getFiniteVersion()) {
                String errorStr = String.format("Stored level version %d is older than current version %d!", this.levelVersion, FiniteDataHandler.getFiniteVersion());
                throw new IllegalStateException(errorStr);
            }
            if (this.levelWidth != levelWidth || this.levelHeight != levelHeight || this.levelLength != levelLength) {
                throw new IllegalStateException("Stored level dimensions were somehow corrupted!");
            }
            if (this.levelData.length != this.levelWidth * this.levelHeight * this.levelLength) {
                throw new IllegalStateException("Stored level size from file was somehow corrupted!");
            }
            for (String registryName : this.levelMap.values()) {
                if (registryName == null) {
                    throw new NullPointerException("Stored block registry name is null!");
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
                if (block != null) continue;
                throw new NullPointerException("Stored block was not found in Forge registry!");
            }
            ModernBeta.log(Level.DEBUG, String.format("Unpacked byte array of size %d", this.levelData.length));
            ModernBeta.log(Level.DEBUG, String.format("Unpacked block map of size %d", this.levelMap.size()));
            return new FiniteChunkSource.LevelDataContainer(this.levelData, this.levelMap);
        }
    }
}

