/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.client.gui.GuiPredicate;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverBeach;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverOcean;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverRiver;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.biome.source.NoiseBiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.compat.dynamictrees.CompatDynamicTrees;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.biomes.alpha.BiomeAlpha;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.biome.biomes.infdev.BiomeInfdev415;
import mod.bespectacled.modernbetaforge.world.biome.biomes.infdev.BiomeInfdev420;
import mod.bespectacled.modernbetaforge.world.chunk.source.SkylandsChunkSource;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPredicates {
    private static final Map<ResourceLocation, List<Integer>> NOISE_SETTINGS = new LinkedHashMap<ResourceLocation, List<Integer>>();
    private static final List<Integer> DEFAULT_NOISE_SETTINGS = ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)507, (Object)508, (Object)510, (Object)511, (Object)512);
    private static final MapGenStronghold STRONGHOLD = new MapGenStronghold();
    public static final GuiPredicate SURFACE_BUILDER_TEST;
    public static final GuiPredicate SPAWN_LOCATOR_TEST;
    public static final GuiPredicate SINGLE_BIOME_TEST;
    public static final GuiPredicate REPLACE_OCEAN_TEST;
    public static final GuiPredicate REPLACE_BEACH_TEST;
    public static final GuiPredicate REPLACE_RIVER_TEST;
    public static final GuiPredicate SEA_LEVEL_TEST;
    public static final GuiPredicate CAVE_WIDTH_TEST;
    public static final GuiPredicate CAVE_HEIGHT_TEST;
    public static final GuiPredicate CAVE_COUNT_TEST;
    public static final GuiPredicate CAVE_CHANCE_TEST;
    public static final GuiPredicate USE_STRONGHOLDS_TEST;
    public static final GuiPredicate USE_VILLAGES_TEST;
    public static final GuiPredicate USE_VILLAGE_VARIANTS_TEST;
    public static final GuiPredicate USE_TEMPLES_TEST;
    public static final GuiPredicate USE_MONUMENTS_TEST;
    public static final GuiPredicate USE_MANSIONS_TEST;
    public static final GuiPredicate DUNGEON_CHANCE_TEST;
    public static final GuiPredicate WATER_LAKE_CHANCE_TEST;
    public static final GuiPredicate LAVA_LAKE_CHANCE_TEST;
    public static final GuiPredicate USE_SANDSTONE_TEST;
    public static final GuiPredicate USE_OLD_NETHER_TEST;
    public static final GuiPredicate USE_NETHER_CAVES_TEST;
    public static final GuiPredicate USE_FORTRESSES_TEST;
    public static final GuiPredicate USE_LAVA_POCKETS_TEST;
    public static final GuiPredicate LEVEL_THEME_TEST;
    public static final GuiPredicate LEVEL_TYPE_TEST;
    public static final GuiPredicate LEVEL_WIDTH_TEST;
    public static final GuiPredicate LEVEL_LENGTH_TEST;
    public static final GuiPredicate LEVEL_HEIGHT_TEST;
    public static final GuiPredicate LEVEL_HOUSE_TEST;
    public static final GuiPredicate USE_INDEV_CAVES_TEST;
    public static final GuiPredicate LEVEL_CAVE_WIDTH_TEST;
    public static final GuiPredicate USE_INFDEV_WALLS_TEST;
    public static final GuiPredicate USE_INFDEV_PYRAMIDS_TEST;
    public static final GuiPredicate RIVER_SIZE_TEST;
    public static final GuiPredicate LAYER_SIZE_TEST;
    public static final GuiPredicate LAYER_TYPE_TEST;
    public static final GuiPredicate USE_TALL_GRASS_TEST;
    public static final GuiPredicate USE_NEW_FLOWERS_TEST;
    public static final GuiPredicate USE_DOUBLE_PLANTS_TEST;
    public static final GuiPredicate USE_LILY_PADS_TEST;
    public static final GuiPredicate USE_MELONS_TEST;
    public static final GuiPredicate USE_DESERT_WELLS_TEST;
    public static final GuiPredicate USE_FOSSILS_TEST;
    public static final GuiPredicate USE_SAND_DISKS_TEST;
    public static final GuiPredicate USE_GRAVEL_DISKS_TEST;
    public static final GuiPredicate USE_CLAY_DISKS_TEST;
    public static final GuiPredicate USE_BIRCH_TREES_TEST;
    public static final GuiPredicate USE_PINE_TREES_TEST;
    public static final GuiPredicate USE_SWAMP_TREES_TEST;
    public static final GuiPredicate USE_JUNGLE_TREES_TEST;
    public static final GuiPredicate USE_ACACIA_TREES_TEST;
    public static final GuiPredicate USE_NEW_FANCY_OAK_TREES_TEST;
    public static final GuiPredicate SPAWN_NEW_CREATURE_MOBS_TEST;
    public static final GuiPredicate SPAWN_NEW_MONSTER_MOBS_TEST;
    public static final GuiPredicate SPAWN_WATER_MOBS_TEST;
    public static final GuiPredicate SPAWN_AMBIENT_MOBS_TEST;
    public static final GuiPredicate SPAWN_WOLVES_TEST;
    public static final GuiPredicate BIOME_SIZE_TEST;
    public static final GuiPredicate SNOWY_BIOME_CHANCE_TEST;
    public static final GuiPredicate USE_OLD_ORES_TEST;
    public static final GuiPredicate CLAY_SIZE_TEST;
    public static final GuiPredicate CLAY_COUNT_TEST;
    public static final GuiPredicate CLAY_MIN_HEIGHT_TEST;
    public static final GuiPredicate CLAY_MAX_HEIGHT_TEST;
    public static final GuiPredicate EMERALD_SIZE_TEST;
    public static final GuiPredicate EMERALD_COUNT_TEST;
    public static final GuiPredicate EMERALD_MIN_HEIGHT_TEST;
    public static final GuiPredicate EMERALD_MAX_HEIGHT_TEST;
    public static final GuiPredicate QUARTZ_SIZE_TEST;
    public static final GuiPredicate QUARTZ_COUNT_TEST;
    public static final GuiPredicate MAGMA_SIZE_TEST;
    public static final GuiPredicate MAGMA_COUNT_TEST;
    public static final GuiPredicate COORDINATE_SCALE_TEST;
    public static final GuiPredicate HEIGHT_SCALE_TEST;
    public static final GuiPredicate LOWER_LIMIT_SCALE_TEST;
    public static final GuiPredicate UPPER_LIMIT_SCALE_TEST;
    public static final GuiPredicate SCALE_NOISE_SCALE_X_TEST;
    public static final GuiPredicate SCALE_NOISE_SCALE_Z_TEST;
    public static final GuiPredicate DEPTH_NOISE_SCALE_X_TEST;
    public static final GuiPredicate DEPTH_NOISE_SCALE_Z_TEST;
    public static final GuiPredicate MAIN_NOISE_SCALE_X_TEST;
    public static final GuiPredicate MAIN_NOISE_SCALE_Y_TEST;
    public static final GuiPredicate MAIN_NOISE_SCALE_Z_TEST;
    public static final GuiPredicate BASE_SIZE_TEST;
    public static final GuiPredicate STRETCH_Y_TEST;
    public static final GuiPredicate HEIGHT_TEST;
    public static final GuiPredicate TEMP_NOISE_SCALE_TEST;
    public static final GuiPredicate RAIN_NOISE_SCALE_TEST;
    public static final GuiPredicate DETAIL_NOISE_SCALE_TEST;
    public static final GuiPredicate SNOW_LINE_OFFSET_TEST;
    public static final GuiPredicate USE_CLIMATE_FEATURES_TEST;
    public static final GuiPredicate BIOME_DEPTH_WEIGHT_TEST;
    public static final GuiPredicate BIOME_DEPTH_OFFSET_TEST;
    public static final GuiPredicate BIOME_SCALE_WEIGHT_TEST;
    public static final GuiPredicate BIOME_SCALE_OFFSET_TEST;
    public static final GuiPredicate USE_BIOME_DEPTH_SCALE_TEST;
    public static final GuiPredicate USE_AMPLIFIED_TEST;
    public static final GuiPredicate END_ISLAND_WEIGHT_TEST;
    public static final GuiPredicate END_ISLAND_OFFSET_TEST;
    public static final GuiPredicate END_OUTER_ISLAND_DISTANCE_TEST;
    public static final GuiPredicate END_OUTER_ISLAND_OFFSET_TEST;
    public static final GuiPredicate USE_END_OUTER_ISLANDS_TEST;
    public static final GuiPredicate BASE_BIOME_TEST;
    public static final GuiPredicate OCEAN_BIOME_TEST;
    public static final GuiPredicate BEACH_BIOME_TEST;
    public static final GuiPredicate DEV_BIOME_PROP_TEST;

    public static boolean isChunkInstanceOf(ModernBetaGeneratorSettings settings, Class<?> clazz) {
        ChunkSource chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(0L, settings);
        return clazz.isAssignableFrom(chunkSource.getClass());
    }

    public static boolean isBiomeInstanceOf(ModernBetaGeneratorSettings settings, Class<?> clazz) {
        BiomeSource biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(0L, settings);
        return clazz.isAssignableFrom(biomeSource.getClass());
    }

    private static boolean isChunkEqualTo(ModernBetaGeneratorSettings settings, ModernBetaBuiltInTypes.Chunk type) {
        return settings.chunkSource.equals((Object)type.getRegistryKey());
    }

    private static boolean isBiomeEqualTo(ModernBetaGeneratorSettings settings, ModernBetaBuiltInTypes.Biome type) {
        return settings.biomeSource.equals((Object)type.getRegistryKey());
    }

    private static boolean isSurfaceEqualTo(ModernBetaGeneratorSettings settings, ModernBetaBuiltInTypes.Surface type) {
        return settings.surfaceBuilder.equals((Object)type.getRegistryKey());
    }

    private static boolean isCarverEqualTo(ModernBetaGeneratorSettings settings, ModernBetaBuiltInTypes.Carver type) {
        return settings.caveCarver.equals((Object)type.getRegistryKey());
    }

    private static boolean isCarverEnabled(ModernBetaGeneratorSettings settings) {
        return !settings.caveCarver.equals((Object)ModernBetaBuiltInTypes.Carver.NONE.getRegistryKey());
    }

    private static boolean isFiniteChunk(ModernBetaGeneratorSettings settings) {
        ChunkSource chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(0L, settings);
        return chunkSource instanceof FiniteChunkSource;
    }

    private static boolean isSingleBiome(ModernBetaGeneratorSettings settings) {
        return GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.SINGLE);
    }

    private static boolean isModernBetaBiome(ModernBetaGeneratorSettings settings) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
        return biome instanceof ModernBetaBiome;
    }

    private static boolean isBetaBiome(ModernBetaGeneratorSettings settings) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
        return biome instanceof BiomeBeta;
    }

    private static boolean isFancyOakBiome(ModernBetaGeneratorSettings settings) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
        return biome instanceof BiomeBeta || biome instanceof BiomeAlpha || biome instanceof BiomeInfdev415 || biome instanceof BiomeInfdev420;
    }

    private static boolean isBetaOrPEBiomeSource(ModernBetaGeneratorSettings settings) {
        return GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.BETA) || GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.PE);
    }

    private static boolean isBetaOrPESource(ModernBetaGeneratorSettings settings) {
        return GuiPredicates.isChunkEqualTo(settings, ModernBetaBuiltInTypes.Chunk.BETA) || GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.BETA) || GuiPredicates.isChunkEqualTo(settings, ModernBetaBuiltInTypes.Chunk.PE) || GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.PE);
    }

    private static boolean isClimateSampler(ModernBetaGeneratorSettings settings) {
        BiomeSource biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(0L, settings);
        return biomeSource instanceof ClimateSampler;
    }

    private static boolean containsNoiseSetting(ModernBetaGeneratorSettings settings, int guiId) {
        ResourceLocation registryKey = settings.chunkSource;
        ChunkSource chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(registryKey).apply(0L, settings);
        if (!(chunkSource instanceof NoiseChunkSource)) {
            return false;
        }
        if (!NOISE_SETTINGS.containsKey(registryKey)) {
            return DEFAULT_NOISE_SETTINGS.contains(guiId);
        }
        return NOISE_SETTINGS.get(registryKey).contains(guiId);
    }

    static {
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.BETA.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)524, (Object)525, (Object)503, (Object)504, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object[])new Integer[]{511, 512}));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.ALPHA.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)524, (Object)525, (Object)503, (Object)504, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object[])new Integer[]{511, 512}));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.INFDEV_611.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)524, (Object)525, (Object)503, (Object)504, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object[])new Integer[]{511, 512}));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.INFDEV_420.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object)511, (Object)512));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.INFDEV_415.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)507, (Object)508, (Object)510, (Object)511, (Object)512));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.INFDEV_227.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)512));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.SKYLANDS.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)507, (Object)508, (Object)510, (Object)511, (Object)512));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.PE.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)524, (Object)525, (Object)503, (Object)504, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object[])new Integer[]{511, 512}));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.RELEASE.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)503, (Object)504, (Object)506, (Object)507, (Object)508, (Object)509, (Object)510, (Object)511, (Object)512, (Object[])new Integer[]{513, 514, 515, 516, 550, 552}));
        NOISE_SETTINGS.put(ModernBetaBuiltInTypes.Chunk.END.getRegistryKey(), (List<Integer>)ImmutableList.of((Object)500, (Object)501, (Object)502, (Object)524, (Object)525, (Object)507, (Object)508, (Object)510, (Object)511, (Object)512, (Object)527, (Object)526, (Object[])new Integer[]{551, 529, 528}));
        SURFACE_BUILDER_TEST = new GuiPredicate(settings -> {
            boolean isFloating = GuiPredicates.isChunkInstanceOf(settings, SkylandsChunkSource.class);
            return !isFloating && !GuiPredicates.isFiniteChunk(settings);
        }, 102, 192);
        SPAWN_LOCATOR_TEST = new GuiPredicate(settings -> !GuiPredicates.isFiniteChunk(settings), 104, 194);
        SINGLE_BIOME_TEST = new GuiPredicate(settings -> GuiPredicates.isSingleBiome(settings), 105);
        REPLACE_OCEAN_TEST = new GuiPredicate(settings -> GuiPredicates.isBiomeInstanceOf(settings, BiomeResolverOcean.class), 106);
        REPLACE_BEACH_TEST = new GuiPredicate(settings -> GuiPredicates.isBiomeInstanceOf(settings, BiomeResolverBeach.class), 107);
        REPLACE_RIVER_TEST = new GuiPredicate(settings -> GuiPredicates.isBiomeInstanceOf(settings, BiomeResolverRiver.class), 108);
        SEA_LEVEL_TEST = new GuiPredicate(SURFACE_BUILDER_TEST::test, 109);
        CAVE_WIDTH_TEST = new GuiPredicate(settings -> !GuiPredicates.isCarverEqualTo(settings, ModernBetaBuiltInTypes.Carver.RELEASE) && GuiPredicates.isCarverEnabled(settings), 130);
        CAVE_HEIGHT_TEST = new GuiPredicate(CAVE_WIDTH_TEST::test, 131);
        CAVE_COUNT_TEST = new GuiPredicate(CAVE_WIDTH_TEST::test, 132);
        CAVE_CHANCE_TEST = new GuiPredicate(CAVE_WIDTH_TEST::test, 133);
        USE_STRONGHOLDS_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            return GuiPredicates.isSingleBiome(settings) ? GuiPredicates.STRONGHOLD.field_151546_e.contains(biome) : true;
        }, 110);
        USE_VILLAGES_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            return GuiPredicates.isSingleBiome(settings) ? MapGenVillage.field_75055_e.contains(biome) : true;
        }, 111);
        USE_VILLAGE_VARIANTS_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            boolean hasVillages = GuiPredicates.isSingleBiome(settings) ? MapGenVillage.field_75055_e.contains(biome) : true;
            return hasVillages && settings.useVillages;
        }, 112);
        USE_TEMPLES_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            return GuiPredicates.isSingleBiome(settings) ? MapGenScatteredFeature.field_75061_e.contains(biome) : true;
        }, 114);
        USE_MONUMENTS_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            return GuiPredicates.isSingleBiome(settings) ? StructureOceanMonument.field_186134_b.contains(biome) : true;
        }, 115);
        USE_MANSIONS_TEST = new GuiPredicate(settings -> {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(settings.singleBiome);
            return GuiPredicates.isSingleBiome(settings) ? WoodlandMansion.field_191072_a.contains(biome) : true;
        }, 116);
        DUNGEON_CHANCE_TEST = new GuiPredicate(settings -> settings.useDungeons, 119);
        WATER_LAKE_CHANCE_TEST = new GuiPredicate(settings -> settings.useWaterLakes, 121);
        LAVA_LAKE_CHANCE_TEST = new GuiPredicate(settings -> settings.useLavaLakes, 123);
        USE_SANDSTONE_TEST = new GuiPredicate(settings -> {
            boolean isReleaseSurface = GuiPredicates.isSurfaceEqualTo(settings, ModernBetaBuiltInTypes.Surface.RELEASE);
            return !isReleaseSurface && !GuiPredicates.isFiniteChunk(settings);
        }, 125);
        USE_OLD_NETHER_TEST = new GuiPredicate(settings -> ModCompat.isNetherCompatible(), 126);
        USE_NETHER_CAVES_TEST = new GuiPredicate(settings -> settings.useOldNether && ModCompat.isNetherCompatible(), 127);
        USE_FORTRESSES_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 128);
        USE_LAVA_POCKETS_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 129);
        LEVEL_THEME_TEST = new GuiPredicate(settings -> GuiPredicates.isChunkEqualTo(settings, ModernBetaBuiltInTypes.Chunk.INDEV), 200);
        LEVEL_TYPE_TEST = new GuiPredicate(LEVEL_THEME_TEST::test, 201);
        LEVEL_WIDTH_TEST = new GuiPredicate(settings -> GuiPredicates.isFiniteChunk(settings), 202);
        LEVEL_LENGTH_TEST = new GuiPredicate(LEVEL_WIDTH_TEST::test, 203);
        LEVEL_HEIGHT_TEST = new GuiPredicate(LEVEL_WIDTH_TEST::test, 204);
        LEVEL_HOUSE_TEST = new GuiPredicate(LEVEL_WIDTH_TEST::test, 205);
        USE_INDEV_CAVES_TEST = new GuiPredicate(LEVEL_WIDTH_TEST::test, 206);
        LEVEL_CAVE_WIDTH_TEST = new GuiPredicate(settings -> GuiPredicates.isFiniteChunk(settings) && settings.useIndevCaves, 207);
        USE_INFDEV_WALLS_TEST = new GuiPredicate(settings -> GuiPredicates.isChunkEqualTo(settings, ModernBetaBuiltInTypes.Chunk.INFDEV_227), 208);
        USE_INFDEV_PYRAMIDS_TEST = new GuiPredicate(USE_INFDEV_WALLS_TEST::test, 209);
        RIVER_SIZE_TEST = new GuiPredicate(settings -> GuiPredicates.isChunkEqualTo(settings, ModernBetaBuiltInTypes.Chunk.RELEASE) && !GuiPredicates.isBiomeInstanceOf(settings, NoiseBiomeSource.class), 210);
        LAYER_SIZE_TEST = new GuiPredicate(RIVER_SIZE_TEST::test, 211);
        LAYER_TYPE_TEST = new GuiPredicate(RIVER_SIZE_TEST::test, 212);
        USE_TALL_GRASS_TEST = new GuiPredicate(settings -> {
            boolean isBetaPEBiomeSource = GuiPredicates.isBetaOrPEBiomeSource(settings);
            boolean isFixedBiomeSource = GuiPredicates.isSingleBiome(settings);
            return isBetaPEBiomeSource || isFixedBiomeSource && GuiPredicates.isModernBetaBiome(settings);
        }, 300);
        USE_NEW_FLOWERS_TEST = new GuiPredicate(settings -> {
            boolean isBetaPEBiomeSource = GuiPredicates.isBetaOrPEBiomeSource(settings);
            boolean isFixedBiomeSource = GuiPredicates.isSingleBiome(settings);
            return isBetaPEBiomeSource || isFixedBiomeSource && GuiPredicates.isBetaBiome(settings);
        }, 301);
        USE_DOUBLE_PLANTS_TEST = new GuiPredicate(USE_NEW_FLOWERS_TEST::test, 315);
        USE_LILY_PADS_TEST = new GuiPredicate(USE_NEW_FLOWERS_TEST::test, 302);
        USE_MELONS_TEST = new GuiPredicate(USE_NEW_FLOWERS_TEST::test, 303);
        USE_DESERT_WELLS_TEST = new GuiPredicate(USE_NEW_FLOWERS_TEST::test, 304);
        USE_FOSSILS_TEST = new GuiPredicate(USE_NEW_FLOWERS_TEST::test, 305);
        USE_SAND_DISKS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 312);
        USE_GRAVEL_DISKS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 313);
        USE_CLAY_DISKS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 314);
        USE_BIRCH_TREES_TEST = new GuiPredicate(settings -> {
            boolean isBetaPEBiomeSource = GuiPredicates.isBetaOrPEBiomeSource(settings);
            boolean isFixedBiomeSource = GuiPredicates.isSingleBiome(settings);
            boolean isDynamicTreesLoaded = ModCompat.isModLoaded("dynamictrees");
            return (!isDynamicTreesLoaded || isDynamicTreesLoaded && !CompatDynamicTrees.isEnabled()) && (isBetaPEBiomeSource || isFixedBiomeSource && GuiPredicates.isBetaBiome(settings));
        }, 306);
        USE_PINE_TREES_TEST = new GuiPredicate(USE_BIRCH_TREES_TEST::test, 307);
        USE_SWAMP_TREES_TEST = new GuiPredicate(USE_BIRCH_TREES_TEST::test, 308);
        USE_JUNGLE_TREES_TEST = new GuiPredicate(USE_BIRCH_TREES_TEST::test, 309);
        USE_ACACIA_TREES_TEST = new GuiPredicate(USE_BIRCH_TREES_TEST::test, 310);
        USE_NEW_FANCY_OAK_TREES_TEST = new GuiPredicate(settings -> {
            boolean isBetaPEBiomeSource = GuiPredicates.isBetaOrPEBiomeSource(settings);
            boolean isFixedBiomeSource = GuiPredicates.isSingleBiome(settings);
            boolean isDynamicTreesLoaded = ModCompat.isModLoaded("dynamictrees");
            return (!isDynamicTreesLoaded || isDynamicTreesLoaded && !CompatDynamicTrees.isEnabled()) && (isBetaPEBiomeSource || isFixedBiomeSource && GuiPredicates.isFancyOakBiome(settings));
        }, 311);
        SPAWN_NEW_CREATURE_MOBS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 320);
        SPAWN_NEW_MONSTER_MOBS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 321);
        SPAWN_WATER_MOBS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 322);
        SPAWN_AMBIENT_MOBS_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 323);
        SPAWN_WOLVES_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 324);
        BIOME_SIZE_TEST = new GuiPredicate(settings -> GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.RELEASE), 330);
        SNOWY_BIOME_CHANCE_TEST = new GuiPredicate(settings -> GuiPredicates.isBiomeEqualTo(settings, ModernBetaBuiltInTypes.Biome.RELEASE), 331);
        USE_OLD_ORES_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 460);
        CLAY_SIZE_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 400);
        CLAY_COUNT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 401);
        CLAY_MIN_HEIGHT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 402);
        CLAY_MAX_HEIGHT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 403);
        EMERALD_SIZE_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 448);
        EMERALD_COUNT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 449);
        EMERALD_MIN_HEIGHT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 450);
        EMERALD_MAX_HEIGHT_TEST = new GuiPredicate(USE_TALL_GRASS_TEST::test, 451);
        QUARTZ_SIZE_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 452);
        QUARTZ_COUNT_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 453);
        MAGMA_SIZE_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 454);
        MAGMA_COUNT_TEST = new GuiPredicate(USE_NETHER_CAVES_TEST::test, 455);
        COORDINATE_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 507), 507, 607);
        HEIGHT_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 508), 508, 608);
        LOWER_LIMIT_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 511), 511, 611);
        UPPER_LIMIT_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 510), 510, 610);
        SCALE_NOISE_SCALE_X_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 524), 524, 624);
        SCALE_NOISE_SCALE_Z_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 525), 525, 625);
        DEPTH_NOISE_SCALE_X_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 503), 503, 603);
        DEPTH_NOISE_SCALE_Z_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 504), 504, 604);
        MAIN_NOISE_SCALE_X_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 500), 500, 600);
        MAIN_NOISE_SCALE_Y_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 501), 501, 601);
        MAIN_NOISE_SCALE_Z_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 502), 502, 602);
        BASE_SIZE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 506), 506, 606);
        STRETCH_Y_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 509), 509, 609);
        HEIGHT_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 512), 512, 612);
        TEMP_NOISE_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.isBetaOrPESource(settings), 520, 620);
        RAIN_NOISE_SCALE_TEST = new GuiPredicate(TEMP_NOISE_SCALE_TEST::test, 521, 621);
        DETAIL_NOISE_SCALE_TEST = new GuiPredicate(TEMP_NOISE_SCALE_TEST::test, 522, 622);
        BIOME_DEPTH_WEIGHT_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 513), 513, 613);
        BIOME_DEPTH_OFFSET_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 514), 514, 614);
        BIOME_SCALE_WEIGHT_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 515), 515, 615);
        BIOME_SCALE_OFFSET_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 516), 516, 616);
        USE_BIOME_DEPTH_SCALE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 550) && !GuiPredicates.isBiomeInstanceOf(settings, NoiseBiomeSource.class), 550);
        USE_AMPLIFIED_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 552), 552);
        END_ISLAND_WEIGHT_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 527), 527, 627);
        END_ISLAND_OFFSET_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 526), 526, 626);
        USE_END_OUTER_ISLANDS_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 551), 551);
        END_OUTER_ISLAND_DISTANCE_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 529) && settings.useEndOuterIslands, 529, 629);
        END_OUTER_ISLAND_OFFSET_TEST = new GuiPredicate(settings -> GuiPredicates.containsNoiseSetting(settings, 528) && settings.useEndOuterIslands, 528, 628);
        BASE_BIOME_TEST = new GuiPredicate(settings -> GuiPredicates.isBetaOrPEBiomeSource(settings), 700, 703, 706, 709, 712, 715, 721, 718, 724, 727, 730);
        OCEAN_BIOME_TEST = new GuiPredicate(settings -> GuiPredicates.isBetaOrPEBiomeSource(settings) && settings.replaceOceanBiomes, 701, 704, 707, 710, 713, 716, 722, 719, 725, 728, 731);
        BEACH_BIOME_TEST = new GuiPredicate(settings -> GuiPredicates.isBetaOrPEBiomeSource(settings) && settings.replaceBeachBiomes, 702, 705, 708, 711, 714, 717, 723, 720, 726, 729, 732);
        SNOW_LINE_OFFSET_TEST = new GuiPredicate(settings -> GuiPredicates.isClimateSampler(settings), 750);
        USE_CLIMATE_FEATURES_TEST = new GuiPredicate(settings -> GuiPredicates.isClimateSampler(settings), 751);
        DEV_BIOME_PROP_TEST = new GuiPredicate(settings -> {
            ResourceLocation registryKey = ModernBeta.createRegistryKey("booleanProp");
            if (settings.containsProperty(registryKey)) {
                return settings.getBooleanProperty(registryKey);
            }
            return true;
        }, new int[0]);
    }
}

