/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.command;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.command.ModernBetaCommand;
import mod.bespectacled.modernbetaforge.util.DrawUtil;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.apache.logging.log4j.Level;

public class CommandDrawMap
extends ModernBetaCommand {
    private static final String NAME = "drawmap";
    private static final String PATH = "map.png";
    private final String path;
    private int percentage = 0;

    public CommandDrawMap() {
        super(NAME);
        this.path = PATH;
    }

    public BufferedImage drawMap(WorldServer worldServer, BlockPos center, int width, int length, Consumer<Float> progressTracker) throws IllegalStateException {
        IChunkGenerator chunkGenerator = worldServer.func_72863_F().field_186029_c;
        BiomeProvider biomeProvider = worldServer.func_72959_q();
        if (chunkGenerator instanceof ModernBetaChunkGenerator && biomeProvider instanceof ModernBetaBiomeProvider) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ModernBetaBiomeProvider modernBetaBiomeProvider = (ModernBetaBiomeProvider)biomeProvider;
            ChunkSource chunkSource = modernBetaChunkGenerator.getChunkSource();
            BiomeSource biomeSource = modernBetaBiomeProvider.getBiomeSource();
            BiomeInjectionRules injectionRules = chunkSource.createBiomeInjectionRules(biomeSource).build();
            SurfaceBuilder surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.get(modernBetaChunkGenerator.getGeneratorSettings().surfaceBuilder).apply(chunkSource, chunkSource.getGeneratorSettings());
            return DrawUtil.createTerrainMap(chunkSource, biomeSource, surfaceBuilder, injectionRules, center.func_177958_n(), center.func_177952_p(), width, length, true, progressTracker, () -> false, null);
        }
        throw new IllegalStateException();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer worldServer = this.validateWorld(server, sender);
        this.validateArgsLength(sender, args, 2, 3);
        boolean success = false;
        int length = MathHelper.func_76125_a((int)(CommandBase.func_175755_a((String)args[0]) >> 4 << 4), (int)0, (int)5120);
        int width = MathHelper.func_76125_a((int)(CommandBase.func_175755_a((String)args[1]) >> 4 << 4), (int)0, (int)5120);
        BlockPos center = args.length == 2 || !CommandBase.func_180527_d((String)args[2]) ? sender.func_180425_c() : BlockPos.field_177992_a;
        center = new BlockPos(center.func_177958_n() >> 4 << 4, center.func_177956_o(), center.func_177952_p() >> 4 << 4);
        try {
            File file = new File(worldServer.func_72860_G().func_75765_b(), this.path);
            file = file.getCanonicalFile();
            CommandDrawMap.func_152373_a((ICommandSender)sender, (ICommand)this, (String)this.getLangString("start"), (Object[])new Object[]{width, length, center.func_177958_n(), center.func_177952_p()});
            BufferedImage image = this.drawMap(worldServer, center, length, width, current -> this.setProgress(current.floatValue(), sender));
            ImageIO.write((RenderedImage)image, "png", file);
            TextComponentString textComponent = new TextComponentString(file.getName());
            textComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getPath()));
            textComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
            CommandDrawMap.func_152373_a((ICommandSender)sender, (ICommand)this, (String)this.getLangString("success"), (Object[])new Object[]{textComponent});
            success = true;
        }
        catch (Exception e) {
            ModernBeta.log(Level.WARN, String.format("Command '%s' failed!", this.name));
        }
        if (!success) {
            throw new CommandException(this.getLangString("failure"), new Object[0]);
        }
    }

    private void setProgress(float current, ICommandSender sender) {
        int percentage = (int)(current * 100.0f);
        if (this.percentage != percentage && percentage % 25 == 0) {
            ModernBeta.log(Level.INFO, I18n.func_135052_a((String)this.getLangString("progress"), (Object[])new Object[]{percentage}));
        }
        this.percentage = percentage;
    }
}

