/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.command;

import mod.bespectacled.modernbetaforge.command.ModernBetaCommand;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;

public abstract class CommandLocate
extends ModernBetaCommand {
    private final PositionLocator locator;

    public CommandLocate(String name, PositionLocator locator) {
        super(name);
        this.locator = locator;
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer worldServer = this.validateWorld(server, sender);
        this.validateArgsLength(sender, args, 1);
        String name = args[0].toLowerCase();
        BlockPos blockPos = this.locator.apply(server, sender, args);
        int senderX = sender.func_180425_c().func_177958_n();
        int senderZ = sender.func_180425_c().func_177952_p();
        if (blockPos == null) {
            throw new CommandException(this.getLangString("failure"), new Object[]{name});
        }
        ModernBetaChunkGenerator chunkGenerator = (ModernBetaChunkGenerator)worldServer.func_72863_F().field_186029_c;
        int x = blockPos.func_177958_n();
        int z = blockPos.func_177952_p();
        int height = Math.max(worldServer.func_189649_b(x, z), chunkGenerator.getChunkSource().getHeight(x, z, HeightmapChunk.Type.OCEAN)) + 1;
        long distance = (long)MathUtil.distance(senderX, senderZ, x, z);
        TextComponentString textPosition = new TextComponentString(String.format("[%d, %d, %d]", x, height, z));
        textPosition.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/tp @s %d %d %d", x, height, z)));
        textPosition.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation(this.getLangString("hover"), new Object[0])));
        textPosition.func_150256_b().func_150238_a(TextFormatting.GREEN);
        TextComponentString textDistance = new TextComponentString("(");
        textDistance.func_150257_a((ITextComponent)new TextComponentTranslation(this.getLangString("distance"), new Object[]{distance}));
        textDistance.func_150258_a(")");
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.getLangString("success"), new Object[]{name, textPosition, textDistance}));
    }

    @FunctionalInterface
    public static interface PositionLocator {
        public BlockPos apply(MinecraftServer var1, ICommandSender var2, String[] var3);
    }
}

