/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.NumberFormat;
import mod.bespectacled.modernbetaforge.command.CommandGeneratorSetting;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;

public class CommandSetGeneratorSetting
extends CommandGeneratorSetting {
    private static final String NAME = "setgeneratorsetting";

    public CommandSetGeneratorSetting() {
        super(NAME);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer worldServer = this.validateWorld(server, sender);
        this.validateArgsLength(sender, args, 2);
        WorldInfo worldInfo = worldServer.func_72912_H();
        String generatorOptions = worldInfo.func_82571_y();
        if (generatorOptions.isEmpty()) {
            generatorOptions = new ModernBetaGeneratorSettings.Factory().toString();
        }
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(generatorOptions, JsonObject.class);
        TextComponentString settingText = new TextComponentString(args[0]);
        settingText.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (!jsonObject.has(args[0])) {
            throw new CommandException(this.getLangString("failure"), new Object[]{settingText});
        }
        JsonElement element = jsonObject.get(args[0]);
        TextComponentString prevText = new TextComponentString(element.toString());
        prevText.func_150256_b().func_150238_a(TextFormatting.AQUA);
        TextComponentString valueText = new TextComponentString(args[1]);
        valueText.func_150256_b().func_150238_a(TextFormatting.AQUA);
        if (!element.isJsonPrimitive()) {
            throw new CommandException(this.getLangString("primitive"), new Object[]{settingText});
        }
        try {
            if (element.getAsJsonPrimitive().isBoolean()) {
                jsonObject.addProperty(args[0], Boolean.valueOf(CommandSetGeneratorSetting.func_180527_d((String)args[1])));
            } else if (element.getAsJsonPrimitive().isNumber()) {
                jsonObject.addProperty(args[0], NumberFormat.getInstance().parse(args[1]));
            } else if (element.getAsJsonPrimitive().isString()) {
                jsonObject.addProperty(args[0], args[1]);
            }
        }
        catch (Exception e) {
            throw new CommandException(this.getLangString("parse"), new Object[]{valueText, settingText});
        }
        try {
            ModernBetaGeneratorSettings.Factory factory = ModernBetaGeneratorSettings.Factory.jsonToFactoryChecked(jsonObject.toString());
            jsonObject = (JsonObject)this.gson.fromJson(factory.toString(), JsonObject.class);
            TextComponentString newValueText = new TextComponentString(jsonObject.get(args[0]).toString());
            newValueText.func_150256_b().func_150238_a(TextFormatting.AQUA);
            TextComponentTranslation warningText = new TextComponentTranslation(this.getLangString("warn"), new Object[0]);
            warningText.func_150256_b().func_150238_a(TextFormatting.RED);
            worldInfo.field_82576_c = factory.toString();
            worldServer.func_72860_G().func_75761_a(worldInfo);
            CommandSetGeneratorSetting.func_152373_a((ICommandSender)sender, (ICommand)this, (String)this.getLangString("success"), (Object[])new Object[]{settingText, newValueText, prevText});
            sender.func_145747_a((ITextComponent)warningText);
        }
        catch (Exception e) {
            throw new CommandException(this.getLangString("failure"), new Object[0]);
        }
    }
}

