/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.compat.buildcraft;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverAddSingleBiome;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.compat.buildcraft.CompatBuildCraftEnergy;
import mod.bespectacled.modernbetaforge.registry.ModernBetaBuiltInTypes;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BuildCraftOilDesertResolver
extends BiomeResolverAddSingleBiome {
    public static final ResourceLocation BIOME_ID = new ResourceLocation("buildcraftenergy", "oil_desert");
    private static final List<BiomeDictionary.Type> REQUIRED_TYPES = Arrays.asList(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
    private final boolean isReleaseBiomeSource;
    private final boolean useCompat;

    public BuildCraftOilDesertResolver(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        super(BIOME_ID, chunkSource.getSeed(), 1847L, 74531L, settings.getFloatProperty(CompatBuildCraftEnergy.KEY_OIL_DESERT_CHANCE));
        this.isReleaseBiomeSource = settings.biomeSource.equals((Object)ModernBetaBuiltInTypes.Biome.RELEASE.getRegistryKey());
        this.useCompat = settings.getBooleanProperty(CompatBuildCraftEnergy.KEY_USE_COMPAT);
    }

    @Override
    public boolean useCustomResolver() {
        return this.useCompat && !this.isReleaseBiomeSource;
    }

    @Override
    public Predicate<BiomeInjectionRules.BiomeInjectionContext> getCustomPredicate() {
        return context -> BiomeDictionary.getTypes((Biome)context.getBiome()).containsAll(REQUIRED_TYPES);
    }
}

