/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.util.JsonHelper;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBasePopulatorJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileWriter;
import mod.bespectacled.modernbetaforge.ModernBeta;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class DynamicTreesPopulator
implements IBiomeDataBasePopulator {
    private static final String CONFIG_FILE_NAME = "modernbetaforge_dynamictrees.cfg";
    private static final ResourceLocation DEFAULT_PATH = ModernBeta.createRegistryKey("worldgen/dynamic_trees.json");
    private final BiomeDataBasePopulatorJson jsonPopulator;

    public DynamicTreesPopulator() {
        DynamicTreesConfigHandler configHandler = new DynamicTreesConfigHandler(DEFAULT_PATH);
        this.jsonPopulator = new BiomeDataBasePopulatorJson(configHandler.readConfig());
    }

    public void populate(BiomeDataBase database) {
        this.jsonPopulator.populate(database);
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new DynamicTreesPopulator());
    }

    private static class DynamicTreesConfigHandler {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private final File configFile = new File(ModernBeta.getConfigDirectory(), "modernbetaforge_dynamictrees.cfg");
        private final JsonElement defaultJson;

        public DynamicTreesConfigHandler(ResourceLocation defaultPath) {
            this.defaultJson = JsonHelper.load((ResourceLocation)defaultPath);
        }

        public JsonElement readConfig() {
            JsonElement loadedJson;
            if (!this.configFile.isFile()) {
                ModernBeta.log(Level.WARN, String.format("Dynamic Trees config file '%s' is missing and couldn't be loaded! A new one will be created!", DynamicTreesPopulator.CONFIG_FILE_NAME));
                this.writeConfig();
            }
            if ((loadedJson = JsonHelper.load((File)this.configFile)) == null) {
                ModernBeta.log(Level.WARN, String.format("Dynamic Trees config file '%s' is corrupted and couldn't be loaded! The default config will be used!", DynamicTreesPopulator.CONFIG_FILE_NAME));
                loadedJson = this.defaultJson;
            }
            return loadedJson;
        }

        private void writeConfig() {
            if (!this.configFile.isFile()) {
                try (FileWriter writer = new FileWriter(this.configFile);){
                    GSON.toJson((Object)this.defaultJson, JsonElement.class, (Appendable)writer);
                }
                catch (Exception e) {
                    ModernBeta.log(Level.ERROR, String.format("Dynamic Trees config file '%s' couldn't be saved!", DynamicTreesPopulator.CONFIG_FILE_NAME));
                    ModernBeta.log(Level.ERROR, "Error: " + e.getMessage());
                }
            }
        }
    }
}

