/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.event;

import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.DebugUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.chunk.source.ReleaseChunkSource;
import mod.bespectacled.modernbetaforge.world.chunk.source.SkylandsChunkSource;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebugInfoEventHandler {
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_71356_B() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            IntegratedServer integratedServer = minecraft.func_71401_C();
            MinecraftServer minecraftServer = integratedServer.func_184102_h();
            WorldServer worldServer = (WorldServer)minecraftServer.func_130014_f_();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_71093_bK != DimensionType.OVERWORLD.func_186068_a()) {
                return;
            }
            IChunkGenerator chunkGenerator = worldServer.func_72863_F().field_186029_c;
            BiomeProvider biomeProvider = worldServer.func_72959_q();
            BlockPos playerPos = player.func_180425_c();
            int x = playerPos.func_177958_n();
            int y = playerPos.func_177956_o();
            int z = playerPos.func_177952_p();
            DebugInfoEventHandler.addDebugText(event, "");
            if (chunkGenerator instanceof ModernBetaChunkGenerator) {
                ChunkSource chunkSource = ((ModernBetaChunkGenerator)chunkGenerator).getChunkSource();
                ModernBetaGeneratorSettings settings = chunkSource.getGeneratorSettings();
                String chunkText = String.format("[Modern Beta] Chunk Source: %s", settings.chunkSource);
                String biomeText = String.format("[Modern Beta] Biome Source: %s", settings.biomeSource);
                String surfaceText = String.format("[Modern Beta] Surface Builder: %s", settings.surfaceBuilder);
                String carverText = String.format("[Modern Beta] Cave Carver: %s", settings.caveCarver);
                String spawnerText = String.format("[Modern Beta] World Spawner: %s", settings.worldSpawner);
                String seaLevelText = String.format("[Modern Beta] Sea level: %d", chunkSource.getSeaLevel());
                DebugInfoEventHandler.addDebugText(event, chunkText);
                DebugInfoEventHandler.addDebugText(event, biomeText);
                if (!(chunkSource instanceof SkylandsChunkSource) && !(chunkSource instanceof FiniteChunkSource)) {
                    DebugInfoEventHandler.addDebugText(event, surfaceText);
                }
                DebugInfoEventHandler.addDebugText(event, carverText);
                DebugInfoEventHandler.addDebugText(event, spawnerText);
                DebugInfoEventHandler.addDebugText(event, "");
                if (!(chunkSource instanceof FiniteChunkSource) || chunkSource instanceof FiniteChunkSource && ((FiniteChunkSource)chunkSource).hasPregenerated()) {
                    String heightmapText = String.format("[Modern Beta] Surface Height: %d Ocean Height: %d Floor Height: %d", chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE), chunkSource.getHeight(x, z, HeightmapChunk.Type.OCEAN), chunkSource.getHeight(x, z, HeightmapChunk.Type.FLOOR));
                    DebugInfoEventHandler.addDebugText(event, heightmapText);
                }
                DebugInfoEventHandler.addDebugText(event, seaLevelText);
                if (chunkSource instanceof NoiseChunkSource) {
                    NoiseChunkSource noiseChunkSource = (NoiseChunkSource)chunkSource;
                    DebugInfoEventHandler.addDebugText(event, "[Modern Beta] " + noiseChunkSource.debugNoiseSettings());
                    DebugInfoEventHandler.addDebugText(event, "[Modern Beta] " + noiseChunkSource.debugNoiseCoordinates(x, y, z));
                    DebugInfoEventHandler.addDebugText(event, "[Modern Beta] " + noiseChunkSource.debugNoiseModifiers(x, y, z));
                }
                if (chunkSource instanceof FiniteChunkSource) {
                    FiniteChunkSource finiteChunkSource = (FiniteChunkSource)chunkSource;
                    int offsetX = finiteChunkSource.getLevelWidth() / 2;
                    int offsetZ = finiteChunkSource.getLevelLength() / 2;
                    boolean inLevel = finiteChunkSource.inWorldBounds(x, z);
                    String finiteInLevelText = String.format("[Modern Beta] In Finite Level: %b", inLevel);
                    String finiteCoordsText = String.format("[Modern Beta] Finite XYZ: %d / %d / %d", x + offsetX, y, z + offsetZ);
                    DebugInfoEventHandler.addDebugText(event, finiteInLevelText);
                    DebugInfoEventHandler.addDebugText(event, finiteCoordsText);
                    if (finiteChunkSource.hasPregenerated()) {
                        String finiteHeightmapText = String.format("[Modern Beta] Finite Surface Height: %d Ocean Height: %d Floor Height: %d", finiteChunkSource.getLevelHeight(x + offsetX, z + offsetZ, HeightmapChunk.Type.SURFACE), finiteChunkSource.getLevelHeight(x + offsetX, z + offsetZ, HeightmapChunk.Type.OCEAN), finiteChunkSource.getLevelHeight(x + offsetX, z + offsetZ, HeightmapChunk.Type.FLOOR));
                        DebugInfoEventHandler.addDebugText(event, finiteHeightmapText);
                    }
                }
                if (chunkSource instanceof ReleaseChunkSource) {
                    ReleaseChunkSource releaseChunkSource = (ReleaseChunkSource)chunkSource;
                    String noisebiome = releaseChunkSource.getNoiseBiome(x, z).func_185359_l();
                    String noiseBiomeText = String.format("[Modern Beta] Release Noise Biome: %s", noisebiome);
                    String layerTypeText = String.format("[Modern Beta] Release Layer Type: %s", settings.layerType);
                    DebugInfoEventHandler.addDebugText(event, noiseBiomeText);
                    DebugInfoEventHandler.addDebugText(event, layerTypeText);
                }
            }
            if (biomeProvider instanceof ModernBetaBiomeProvider) {
                ModernBetaBiomeProvider modernBetaBiomeProvider = (ModernBetaBiomeProvider)biomeProvider;
                BiomeSource biomeSource = modernBetaBiomeProvider.getBiomeSource();
                if (biomeSource instanceof ClimateSampler) {
                    ClimateSampler climateSampler = (ClimateSampler)((Object)biomeSource);
                    Clime clime = climateSampler.sample(x, z);
                    double temp = clime.temp();
                    double rain = clime.rain();
                    String climateText = String.format("[Modern Beta] Climate Temp: %.3f Rainfall: %.3f", temp, rain);
                    DebugInfoEventHandler.addDebugText(event, climateText);
                }
                String baseBiomeText = String.format("[Modern Beta] Base Biome: %s", modernBetaBiomeProvider.getBaseBiome(x, z).func_185359_l());
                DebugInfoEventHandler.addDebugText(event, baseBiomeText);
                DebugInfoEventHandler.addDebugText(event, "");
            }
            DebugInfoEventHandler.addGenDebugText(event, "generateChunk");
            DebugInfoEventHandler.addGenDebugText(event, "populate");
            DebugInfoEventHandler.addGenDebugText(event, "getBaseBiomes");
        }
    }

    private static void addDebugText(RenderGameOverlayEvent.Text event, String text) {
        if (ModernBetaConfig.debugOptions.displayDebugInfo) {
            event.getLeft().add(text);
        }
    }

    private static void addGenDebugText(RenderGameOverlayEvent.Text event, String section) {
        String averageTime = DebugUtil.getAverageTime(section);
        String iterations = DebugUtil.getIterations(section);
        if (!averageTime.isEmpty()) {
            DebugInfoEventHandler.addDebugText(event, "[Modern Beta] " + averageTime);
        }
        if (!iterations.isEmpty()) {
            DebugInfoEventHandler.addDebugText(event, "[Modern Beta] " + iterations);
        }
    }
}

